/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.ParameterType;
import java.util.List;
import java.util.SortedSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AmbiguousParameterTypeException
extends CucumberExpressionException {
    private final Pattern regexp;
    private final String parameterTypeRegexp;
    private final SortedSet<ParameterType<?>> parameterTypes;
    private final List<GeneratedExpression> generatedExpressions;

    public AmbiguousParameterTypeException(String parameterTypeRegexp, Pattern expressionRegexp, SortedSet<ParameterType<?>> parameterTypes, List<GeneratedExpression> generatedExpressions) {
        super(String.format("Your Regular Expression /%s/\nmatches multiple parameter types with regexp /%s/:\n   %s\n\nI couldn't decide which one to use. You have two options:\n\n1) Use a Cucumber Expression instead of a Regular Expression. Try one of these:\n   %s\n\n2) Make one of the parameter types preferential and continue to use a Regular Expression.\n\n", expressionRegexp.pattern(), parameterTypeRegexp, AmbiguousParameterTypeException.parameterTypeNames(parameterTypes), AmbiguousParameterTypeException.expressions(generatedExpressions)));
        this.regexp = expressionRegexp;
        this.parameterTypeRegexp = parameterTypeRegexp;
        this.parameterTypes = parameterTypes;
        this.generatedExpressions = generatedExpressions;
    }

    private static String parameterTypeNames(SortedSet<ParameterType<?>> parameterTypes) {
        return parameterTypes.stream().map(p -> "{" + p.getName() + "}").collect(Collectors.joining("\n   "));
    }

    private static String expressions(List<GeneratedExpression> generatedExpressions) {
        return generatedExpressions.stream().map(GeneratedExpression::getSource).collect(Collectors.joining("\n   "));
    }

    public Pattern getRegexp() {
        return this.regexp;
    }

    public String getParameterTypeRegexp() {
        return this.parameterTypeRegexp;
    }

    public SortedSet<ParameterType<?>> getParameterTypes() {
        return this.parameterTypes;
    }

    public List<GeneratedExpression> getGeneratedExpressions() {
        return this.generatedExpressions;
    }
}

