/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Argument;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import io.cucumber.cucumberexpressions.SingleTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegularExpression
implements Expression {
    private static final Pattern CAPTURE_GROUP_PATTERN = Pattern.compile("\\((?!\\?:)([^(]+)\\)");
    private final Pattern expressionRegexp;
    private final ParameterTypeRegistry parameterTypeRegistry;

    public RegularExpression(Pattern expressionRegexp, ParameterTypeRegistry parameterTypeRegistry) {
        this.expressionRegexp = expressionRegexp;
        this.parameterTypeRegistry = parameterTypeRegistry;
    }

    @Override
    public List<Argument<?>> match(String text) {
        ArrayList parameterTypes = new ArrayList();
        Matcher matcher = CAPTURE_GROUP_PATTERN.matcher(this.expressionRegexp.pattern());
        while (matcher.find()) {
            String parameterTypeRegexp = matcher.group(1);
            ParameterType<Object> parameterType = this.parameterTypeRegistry.lookupByRegexp(parameterTypeRegexp, this.expressionRegexp, text);
            if (parameterType == null) {
                parameterType = new ParameterType<String>("*", parameterTypeRegexp, String.class, new SingleTransformer<String>(String::new));
            }
            parameterTypes.add(parameterType);
        }
        return Argument.build(this.expressionRegexp, text, parameterTypes);
    }

    @Override
    public String getSource() {
        return this.expressionRegexp.pattern();
    }
}

