/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.AmbiguousParameterTypeException;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.CucumberExpressionGenerator;
import io.cucumber.cucumberexpressions.DuplicateTypeNameException;
import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.NumberParser;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.SingleTransformer;
import io.cucumber.cucumberexpressions.Transformer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class ParameterTypeRegistry {
    private static final List<String> INTEGER_REGEXPS = Arrays.asList("-?\\d+", "\\d+");
    private static final List<String> FLOAT_REGEXPS = Collections.singletonList("-?\\d*[\\.,]\\d+");
    private static final List<String> HEX_REGEXPS = Collections.singletonList("0[xX][0-9a-fA-F]{2}");
    private static final List<String> WORD_REGEXPS = Collections.singletonList("\\w+");
    private static final List<String> STRING_REGEXPS = Collections.singletonList("\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)\"|\\'([^\\'\\\\]*(\\\\.[^\\'\\\\]*)*)\\'");
    private final Map<String, ParameterType<?>> parameterTypeByName = new HashMap();
    private final Map<String, SortedSet<ParameterType<?>>> parameterTypesByRegexp = new HashMap();

    public ParameterTypeRegistry(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        NumberParser numberParser = new NumberParser(numberFormat);
        this.defineParameterType(new ParameterType<BigInteger>("bigint", INTEGER_REGEXPS, (Type)((Object)BigInteger.class), (Transformer<BigInteger>)new SingleTransformer<BigInteger>(BigInteger::new), false, false));
        this.defineParameterType(new ParameterType<BigDecimal>("bigdecimal", INTEGER_REGEXPS, (Type)((Object)BigDecimal.class), (Transformer<BigDecimal>)new SingleTransformer<BigDecimal>(BigDecimal::new), false, false));
        this.defineParameterType(new ParameterType<Byte>("byte", HEX_REGEXPS, (Type)((Object)Byte.class), (Transformer<Byte>)new SingleTransformer<Byte>(Byte::decode), false, false));
        this.defineParameterType(new ParameterType<Short>("short", INTEGER_REGEXPS, (Type)((Object)Short.class), (Transformer<Short>)new SingleTransformer<Short>(Short::decode), false, false));
        this.defineParameterType(new ParameterType<Integer>("int", INTEGER_REGEXPS, (Type)((Object)Integer.class), (Transformer<Integer>)new SingleTransformer<Integer>(Integer::decode), true, true));
        this.defineParameterType(new ParameterType<Long>("long", INTEGER_REGEXPS, (Type)((Object)Long.class), (Transformer<Long>)new SingleTransformer<Long>(Long::decode), false, false));
        this.defineParameterType(new ParameterType<Float>("float", FLOAT_REGEXPS, (Type)((Object)Float.class), (Transformer<Float>)new SingleTransformer<Float>(numberParser::parseFloat), false, false));
        this.defineParameterType(new ParameterType<Double>("double", FLOAT_REGEXPS, (Type)((Object)Double.class), (Transformer<Double>)new SingleTransformer<Double>(numberParser::parseDouble), true, true));
        this.defineParameterType(new ParameterType<String>("word", WORD_REGEXPS, (Type)((Object)String.class), (Transformer<String>)new SingleTransformer<String>(s -> s), false, false));
        this.defineParameterType(new ParameterType<String>("string", STRING_REGEXPS, (Type)((Object)String.class), (Transformer<String>)new SingleTransformer<String>(s -> s.replaceAll("\\\\\"", "\"").replaceAll("\\\\'", "'")), true, false));
    }

    public void defineParameterType(ParameterType<?> parameterType) {
        if (this.parameterTypeByName.containsKey(parameterType.getName())) {
            throw new DuplicateTypeNameException(String.format("There is already a parameter type with name %s", parameterType.getName()));
        }
        this.parameterTypeByName.put(parameterType.getName(), parameterType);
        for (String parameterTypeRegexp : parameterType.getRegexps()) {
            SortedSet parameterTypes = this.parameterTypesByRegexp.computeIfAbsent(parameterTypeRegexp, r -> new TreeSet());
            if (!parameterTypes.isEmpty() && ((ParameterType)parameterTypes.first()).preferForRegexpMatch() && parameterType.preferForRegexpMatch()) {
                throw new CucumberExpressionException(String.format("There can only be one preferential parameter type per regexp. The regexp /%s/ is used for two preferential parameter types, {%s} and {%s}", parameterTypeRegexp, ((ParameterType)parameterTypes.first()).getName(), parameterType.getName()));
            }
            parameterTypes.add(parameterType);
        }
    }

    public <T> ParameterType<T> lookupByTypeName(String typeName) {
        return this.parameterTypeByName.get(typeName);
    }

    public <T> ParameterType<T> lookupByRegexp(String parameterTypeRegexp, Pattern expressionRegexp, String text) {
        SortedSet<ParameterType<?>> parameterTypes = this.parameterTypesByRegexp.get(parameterTypeRegexp);
        if (parameterTypes == null) {
            return null;
        }
        if (parameterTypes.size() > 1 && !parameterTypes.first().preferForRegexpMatch()) {
            List<GeneratedExpression> generatedExpressions = new CucumberExpressionGenerator(this).generateExpressions(text);
            throw new AmbiguousParameterTypeException(parameterTypeRegexp, expressionRegexp, parameterTypes, generatedExpressions);
        }
        return parameterTypes.first();
    }

    public Collection<ParameterType<?>> getParameterTypes() {
        return this.parameterTypeByName.values();
    }
}

