/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

class Group {
    private final int start;
    private final int end;
    private final String value;
    private final List<Group> children = new ArrayList<Group>();

    public Group(Matcher matcher) {
        if (matcher.groupCount() == 0) {
            this.end = -1;
            this.start = -1;
            this.value = null;
            return;
        }
        this.start = matcher.start(0);
        this.end = matcher.end(0);
        this.value = matcher.group(0);
        ArrayList<Group> stack = new ArrayList<Group>();
        stack.add(this);
        for (int groupIndex = 1; groupIndex <= matcher.groupCount(); ++groupIndex) {
            Group group = new Group(matcher.start(groupIndex), matcher.end(groupIndex), matcher.group(groupIndex));
            while (!((Group)stack.get(stack.size() - 1)).contains(group)) {
                stack.remove(stack.size() - 1);
            }
            ((Group)stack.get(stack.size() - 1)).add(group);
            stack.add(group);
        }
    }

    public Group(int start, int end, String value) {
        this.start = start;
        this.end = end;
        this.value = value;
    }

    public boolean contains(Group group) {
        return group.isNull() || group.start >= this.start && group.end <= this.end;
    }

    public void add(Group group) {
        this.children.add(group);
    }

    public List<Group> getChildren() {
        return this.children;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public List<String> getValues() {
        return (this.getChildren().isEmpty() ? Collections.singletonList(this) : this.getChildren()).stream().map(Group::getValue).collect(Collectors.toList());
    }
}

