/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Function;
import io.cucumber.cucumberexpressions.NumberParser;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.SimpleParameterType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ParameterTypeRegistry {
    private static final List<String> INTEGER_REGEXPS = Arrays.asList("-?\\d+", "\\d+");
    private static final String FLOAT_REGEXP = "-?\\d*[\\.,]\\d+";
    private static final String HEX_REGEXP = "0[xX][0-9a-fA-F]{2}";
    private final Map<Type, ParameterType<?>> parameterTypesByType = new HashMap();
    private final Map<String, ParameterType<?>> parameterTypesByTypeName = new HashMap();
    private final Map<String, ParameterType<?>> parameterTypesByRegexp = new HashMap();

    public ParameterTypeRegistry(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        final NumberParser numberParser = new NumberParser(numberFormat);
        this.definePredefinedParameterType(new SimpleParameterType<BigInteger>("bigint", BigInteger.class, INTEGER_REGEXPS, new Function<String, BigInteger>(){

            @Override
            public BigInteger apply(String s) {
                return new BigInteger(s);
            }
        }));
        this.definePredefinedParameterType(new SimpleParameterType<BigDecimal>("bigdecimal", BigDecimal.class, INTEGER_REGEXPS, new Function<String, BigDecimal>(){

            @Override
            public BigDecimal apply(String s) {
                return new BigDecimal(s);
            }
        }));
        this.definePredefinedParameterType(new SimpleParameterType<Byte>("byte", Byte.TYPE, HEX_REGEXP, new Function<String, Byte>(){

            @Override
            public Byte apply(String s) {
                return Byte.decode(s);
            }
        }));
        this.definePredefinedParameterType(new SimpleParameterType<Byte>("byte", Byte.class, HEX_REGEXP, new Function<String, Byte>(){

            @Override
            public Byte apply(String s) {
                return Byte.decode(s);
            }
        }));
        this.definePredefinedParameterType(new SimpleParameterType<Short>("short", Short.TYPE, INTEGER_REGEXPS, new Function<String, Short>(){

            @Override
            public Short apply(String s) {
                return Short.decode(s);
            }
        }));
        this.definePredefinedParameterType(new SimpleParameterType<Short>("short", Short.class, INTEGER_REGEXPS, new Function<String, Short>(){

            @Override
            public Short apply(String s) {
                return Short.decode(s);
            }
        }));
        this.definePredefinedParameterType(new SimpleParameterType<Integer>("int", Integer.TYPE, INTEGER_REGEXPS, new Function<String, Integer>(){

            @Override
            public Integer apply(String s) {
                return Integer.decode(s);
            }
        }));
        this.definePredefinedParameterType(new SimpleParameterType<Integer>("int", Integer.class, INTEGER_REGEXPS, new Function<String, Integer>(){

            @Override
            public Integer apply(String s) {
                return Integer.decode(s);
            }
        }));
        this.definePredefinedParameterType(new SimpleParameterType<Long>("long", Long.TYPE, INTEGER_REGEXPS, new Function<String, Long>(){

            @Override
            public Long apply(String s) {
                return Long.decode(s);
            }
        }));
        this.definePredefinedParameterType(new SimpleParameterType<Long>("long", Long.class, INTEGER_REGEXPS, new Function<String, Long>(){

            @Override
            public Long apply(String s) {
                return Long.decode(s);
            }
        }));
        this.definePredefinedParameterType(new SimpleParameterType<Float>("float", Float.TYPE, FLOAT_REGEXP, new Function<String, Float>(){

            @Override
            public Float apply(String s) {
                return Float.valueOf(numberParser.parseFloat(s));
            }
        }));
        this.definePredefinedParameterType(new SimpleParameterType<Float>("float", Float.class, FLOAT_REGEXP, new Function<String, Float>(){

            @Override
            public Float apply(String s) {
                return Float.valueOf(numberParser.parseFloat(s));
            }
        }));
        this.definePredefinedParameterType(new SimpleParameterType<Double>("double", Double.TYPE, FLOAT_REGEXP, new Function<String, Double>(){

            @Override
            public Double apply(String s) {
                return numberParser.parseDouble(s);
            }
        }));
        this.definePredefinedParameterType(new SimpleParameterType<Double>("double", Double.class, FLOAT_REGEXP, new Function<String, Double>(){

            @Override
            public Double apply(String s) {
                return numberParser.parseDouble(s);
            }
        }));
    }

    public void defineParameterType(ParameterType<?> parameterType) {
        this.defineParameterType0(parameterType, true);
    }

    private void definePredefinedParameterType(ParameterType<?> parameterType) {
        this.defineParameterType0(parameterType, false);
    }

    private void defineParameterType0(ParameterType<?> parameterType, boolean checkConflicts) {
        if (parameterType.getType() != null) {
            this.put(this.parameterTypesByType, parameterType.getType(), parameterType, "type", parameterType.getType().getTypeName(), checkConflicts);
        }
        this.put(this.parameterTypesByTypeName, parameterType.getName(), parameterType, "type name", parameterType.getName(), checkConflicts);
        for (String captureGroupRegexp : parameterType.getRegexps()) {
            this.put(this.parameterTypesByRegexp, captureGroupRegexp, parameterType, "regexp", captureGroupRegexp, checkConflicts);
        }
    }

    private <K> void put(Map<K, ParameterType<?>> map, K key, ParameterType<?> parameterType, String prop, String keyName, boolean checkConflicts) {
        if (checkConflicts && map.containsKey(key)) {
            throw new RuntimeException(String.format("There is already a parameter type with %s %s", prop, keyName));
        }
        map.put(key, parameterType);
    }

    public <T> ParameterType<T> lookupByType(Type type) {
        return this.parameterTypesByType.get(type);
    }

    public <T> ParameterType<T> lookupByTypeName(String typeName) {
        return this.parameterTypesByTypeName.get(typeName);
    }

    public <T> ParameterType<T> lookupByRegexp(String regexp) {
        return this.parameterTypesByRegexp.get(regexp);
    }

    public Collection<ParameterType<?>> getParameters() {
        return this.parameterTypesByType.values();
    }
}

