/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.ParameterTypeMatcher;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CucumberExpressionGenerator {
    private static final Collator ENGLISH_COLLATOR = Collator.getInstance(Locale.ENGLISH);
    private static final String[] JAVA_KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private final ParameterTypeRegistry parameterTypeRegistry;

    private static boolean isJavaKeyword(String keyword) {
        return Arrays.binarySearch(JAVA_KEYWORDS, keyword, ENGLISH_COLLATOR) >= 0;
    }

    public CucumberExpressionGenerator(ParameterTypeRegistry parameterTypeRegistry) {
        this.parameterTypeRegistry = parameterTypeRegistry;
    }

    public GeneratedExpression generateExpression(String text) {
        ParameterTypeMatcher bestParameterTypeMatcher;
        ArrayList<String> parameterNames = new ArrayList<String>();
        List<ParameterTypeMatcher> parameterTypeMatchers = this.createParameterTypeMatchers(text);
        ArrayList parameterTypes = new ArrayList();
        HashMap<String, Integer> usageByTypeName = new HashMap<String, Integer>();
        StringBuilder expression = new StringBuilder();
        int pos = 0;
        do {
            ArrayList<ParameterTypeMatcher> matchingParameterTypeMatchers = new ArrayList<ParameterTypeMatcher>();
            for (ParameterTypeMatcher parameterTypeMatcher : parameterTypeMatchers) {
                ParameterTypeMatcher advancedParameterTypeMatcher = parameterTypeMatcher.advanceTo(pos);
                if (!advancedParameterTypeMatcher.find()) continue;
                matchingParameterTypeMatchers.add(advancedParameterTypeMatcher);
            }
            if (matchingParameterTypeMatchers.isEmpty()) break;
            Collections.sort(matchingParameterTypeMatchers);
            bestParameterTypeMatcher = (ParameterTypeMatcher)matchingParameterTypeMatchers.get(0);
            ParameterType<?> parameterType = bestParameterTypeMatcher.getParameterType();
            parameterTypes.add(parameterType);
            String parameterName = this.getParameterName(parameterType.getName(), usageByTypeName);
            parameterNames.add(parameterName);
            expression.append(text.substring(pos, bestParameterTypeMatcher.start())).append("{").append(parameterType.getName()).append("}");
        } while ((pos = bestParameterTypeMatcher.start() + bestParameterTypeMatcher.group().length()) < text.length());
        expression.append(text.substring(pos));
        return new GeneratedExpression(expression.toString(), parameterNames, parameterTypes);
    }

    private String getParameterName(String typeName, Map<String, Integer> usageByTypeName) {
        Integer count = usageByTypeName.get(typeName);
        count = count != null ? count + 1 : 1;
        usageByTypeName.put(typeName, count);
        return count == 1 && !CucumberExpressionGenerator.isJavaKeyword(typeName) ? typeName : typeName + count;
    }

    private List<ParameterTypeMatcher> createParameterTypeMatchers(String text) {
        Collection<ParameterType<?>> parameterTypes = this.parameterTypeRegistry.getParameters();
        ArrayList<ParameterTypeMatcher> parameterTypeMatchers = new ArrayList<ParameterTypeMatcher>();
        for (ParameterType<?> parameterType : parameterTypes) {
            parameterTypeMatchers.addAll(this.createParameterTypeMatchers(parameterType, text));
        }
        return parameterTypeMatchers;
    }

    private List<ParameterTypeMatcher> createParameterTypeMatchers(ParameterType<?> parameterType, String text) {
        ArrayList<ParameterTypeMatcher> result = new ArrayList<ParameterTypeMatcher>();
        List<String> captureGroupRegexps = parameterType.getRegexps();
        for (String captureGroupRegexp : captureGroupRegexps) {
            Pattern regexp = Pattern.compile("(" + captureGroupRegexp + ")");
            Matcher matcher = regexp.matcher(text);
            result.add(new ParameterTypeMatcher(parameterType, matcher, text.length()));
        }
        return result;
    }
}

