/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Argument;
import io.cucumber.cucumberexpressions.ArgumentBuilder;
import io.cucumber.cucumberexpressions.ClassParameter;
import io.cucumber.cucumberexpressions.ConstructorParameter;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.Parameter;
import io.cucumber.cucumberexpressions.ParameterRegistry;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegularExpression
implements Expression {
    private static final Pattern CAPTURE_GROUP_PATTERN = Pattern.compile("\\(([^(]+)\\)");
    private final Pattern pattern;
    private final List<Parameter<?>> parameters;

    public RegularExpression(Pattern pattern, List<? extends Type> types, ParameterRegistry parameterRegistry) {
        this.pattern = pattern;
        this.parameters = new ArrayList();
        Matcher matcher = CAPTURE_GROUP_PATTERN.matcher(pattern.pattern());
        int typeIndex = 0;
        while (matcher.find()) {
            Type type = types.size() <= typeIndex ? null : types.get(typeIndex++);
            String captureGroupPattern = matcher.group(1);
            Parameter parameter = null;
            if (type != null) {
                parameter = parameterRegistry.lookupByType(type);
            }
            if (parameter == null) {
                parameter = parameterRegistry.lookupByCaptureGroupRegexp(captureGroupPattern);
            }
            if (parameter == null && type != null && type instanceof Class) {
                parameter = new ClassParameter((Class)type);
            }
            if (parameter == null) {
                parameter = new ConstructorParameter<String>(String.class);
            }
            this.parameters.add(parameter);
        }
    }

    @Override
    public List<Argument> match(String text) {
        return ArgumentBuilder.buildArguments(this.pattern, text, this.parameters);
    }

    @Override
    public String getSource() {
        return this.pattern.pattern();
    }
}

