/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Parameter;
import java.util.regex.Matcher;

class ParameterMatcher
implements Comparable<ParameterMatcher> {
    private final Parameter<?> parameter;
    private final Matcher matcher;
    private final int textLength;

    public ParameterMatcher(Parameter<?> parameter, Matcher matcher, int textLength) {
        this.parameter = parameter;
        this.matcher = matcher;
        this.textLength = textLength;
    }

    public ParameterMatcher advanceTo(int newMatchPos) {
        return new ParameterMatcher(this.parameter, this.matcher.region(newMatchPos, this.textLength), this.textLength);
    }

    public boolean find() {
        return this.matcher.find();
    }

    public int start() {
        return this.matcher.start();
    }

    public String group() {
        return this.matcher.group();
    }

    @Override
    public int compareTo(ParameterMatcher o) {
        int posComparison = Integer.compare(this.start(), o.start());
        if (posComparison != 0) {
            return posComparison;
        }
        int lengthComparison = Integer.compare(o.group().length(), this.group().length());
        if (lengthComparison != 0) {
            return lengthComparison;
        }
        if (this.parameter.getType().equals(Integer.TYPE)) {
            return -1;
        }
        if (this.parameter.getType().equals(Double.TYPE)) {
            return -1;
        }
        return 0;
    }

    public Parameter<?> getParameter() {
        return this.parameter;
    }
}

