/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Function;
import io.cucumber.cucumberexpressions.NumberParser;
import io.cucumber.cucumberexpressions.Parameter;
import io.cucumber.cucumberexpressions.SimpleParameter;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ParameterRegistry {
    private static final List<String> FIXNUM_REGEXPS = Arrays.asList("-?\\d+", "\\d+");
    private static final List<String> FLOATING_POINT_REGEXPS = Collections.singletonList("-?\\d*[\\.,]\\d+");
    private Map<Type, Parameter<?>> parametersByType = new HashMap();
    private Map<String, Parameter<?>> parametersByTypeName = new HashMap();
    private Map<String, Parameter<?>> parametersByCaptureGroupRegexp = new HashMap();

    public ParameterRegistry(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        final NumberParser numberParser = new NumberParser(numberFormat);
        this.addParameter(new SimpleParameter<Byte>("byte", Byte.TYPE, FIXNUM_REGEXPS, new Function<String, Byte>(){

            @Override
            public Byte apply(String s) {
                return numberParser.parseByte(s);
            }
        }));
        this.addParameter(new SimpleParameter<Byte>("byte", Byte.class, FIXNUM_REGEXPS, new Function<String, Byte>(){

            @Override
            public Byte apply(String s) {
                return numberParser.parseByte(s);
            }
        }));
        this.addParameter(new SimpleParameter<Short>("short", Short.TYPE, FIXNUM_REGEXPS, new Function<String, Short>(){

            @Override
            public Short apply(String s) {
                return numberParser.parseShort(s);
            }
        }));
        this.addParameter(new SimpleParameter<Short>("short", Short.class, FIXNUM_REGEXPS, new Function<String, Short>(){

            @Override
            public Short apply(String s) {
                return numberParser.parseShort(s);
            }
        }));
        this.addParameter(new SimpleParameter<Integer>("int", Integer.TYPE, FIXNUM_REGEXPS, new Function<String, Integer>(){

            @Override
            public Integer apply(String s) {
                return numberParser.parseInt(s);
            }
        }));
        this.addParameter(new SimpleParameter<Integer>("int", Integer.class, FIXNUM_REGEXPS, new Function<String, Integer>(){

            @Override
            public Integer apply(String s) {
                return numberParser.parseInt(s);
            }
        }));
        this.addParameter(new SimpleParameter<Long>("long", Long.TYPE, FIXNUM_REGEXPS, new Function<String, Long>(){

            @Override
            public Long apply(String s) {
                return numberParser.parseLong(s);
            }
        }));
        this.addParameter(new SimpleParameter<Long>("long", Long.class, FIXNUM_REGEXPS, new Function<String, Long>(){

            @Override
            public Long apply(String s) {
                return numberParser.parseLong(s);
            }
        }));
        this.addParameter(new SimpleParameter<Float>("float", Float.TYPE, FLOATING_POINT_REGEXPS, new Function<String, Float>(){

            @Override
            public Float apply(String s) {
                return Float.valueOf(numberParser.parseFloat(s));
            }
        }));
        this.addParameter(new SimpleParameter<Float>("float", Float.class, FLOATING_POINT_REGEXPS, new Function<String, Float>(){

            @Override
            public Float apply(String s) {
                return Float.valueOf(numberParser.parseFloat(s));
            }
        }));
        this.addParameter(new SimpleParameter<Double>("double", Double.TYPE, FLOATING_POINT_REGEXPS, new Function<String, Double>(){

            @Override
            public Double apply(String s) {
                return numberParser.parseDouble(s);
            }
        }));
        this.addParameter(new SimpleParameter<Double>("double", Double.class, FLOATING_POINT_REGEXPS, new Function<String, Double>(){

            @Override
            public Double apply(String s) {
                return numberParser.parseDouble(s);
            }
        }));
    }

    public void addParameter(Parameter<?> parameter) {
        this.parametersByType.put(parameter.getType(), parameter);
        this.parametersByTypeName.put(parameter.getTypeName(), parameter);
        for (String captureGroupRegexp : parameter.getCaptureGroupRegexps()) {
            this.parametersByCaptureGroupRegexp.put(captureGroupRegexp, parameter);
        }
    }

    public <T> Parameter<T> lookupByType(Type type) {
        return this.parametersByType.get(type);
    }

    public <T> Parameter<T> lookupByTypeName(String typeName) {
        return this.parametersByTypeName.get(typeName);
    }

    public <T> Parameter<T> lookupByCaptureGroupRegexp(String captureGroupPattern) {
        return this.parametersByCaptureGroupRegexp.get(captureGroupPattern);
    }

    public Collection<Parameter<?>> getParameters() {
        return this.parametersByType.values();
    }
}

