/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import java.text.NumberFormat;
import java.text.ParseException;

class NumberParser {
    private final NumberFormat numberFormat;

    NumberParser(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    double parseDouble(String s) {
        return this.parse(s).doubleValue();
    }

    float parseFloat(String s) {
        return this.parse(s).floatValue();
    }

    byte parseByte(String s) {
        return this.parse(s).byteValue();
    }

    int parseInt(String s) {
        return this.parse(s).intValue();
    }

    long parseLong(String s) {
        return this.parse(s).longValue();
    }

    short parseShort(String s) {
        return this.parse(s).shortValue();
    }

    private Number parse(String s) {
        try {
            return this.numberFormat.parse(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

