/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.Parameter;
import io.cucumber.cucumberexpressions.ParameterMatcher;
import io.cucumber.cucumberexpressions.ParameterRegistry;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CucumberExpressionGenerator {
    private static final Collator ENGLISH_COLLATOR = Collator.getInstance(Locale.ENGLISH);
    private static final String[] JAVA_KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private final ParameterRegistry parameterRegistry;

    private static boolean isJavaKeyword(String keyword) {
        return Arrays.binarySearch(JAVA_KEYWORDS, keyword, ENGLISH_COLLATOR) >= 0;
    }

    public CucumberExpressionGenerator(ParameterRegistry parameterRegistry) {
        this.parameterRegistry = parameterRegistry;
    }

    public GeneratedExpression generateExpression(String text) {
        ParameterMatcher bestParameterMatcher;
        ArrayList<String> parameterNames = new ArrayList<String>();
        List<ParameterMatcher> parameterMatchers = this.createTransformMatchers(text);
        ArrayList parameters = new ArrayList();
        HashMap<String, Integer> usageByTypeName = new HashMap<String, Integer>();
        StringBuilder expression = new StringBuilder();
        int pos = 0;
        do {
            ArrayList<ParameterMatcher> matchingParameterMatchers = new ArrayList<ParameterMatcher>();
            for (ParameterMatcher parameterMatcher : parameterMatchers) {
                ParameterMatcher advancedParameterMatcher = parameterMatcher.advanceTo(pos);
                if (!advancedParameterMatcher.find()) continue;
                matchingParameterMatchers.add(advancedParameterMatcher);
            }
            if (matchingParameterMatchers.isEmpty()) break;
            Collections.sort(matchingParameterMatchers);
            bestParameterMatcher = (ParameterMatcher)matchingParameterMatchers.get(0);
            Parameter<?> parameter = bestParameterMatcher.getParameter();
            parameters.add(parameter);
            String parameterName = this.getParameterName(parameter.getTypeName(), usageByTypeName);
            parameterNames.add(parameterName);
            expression.append(text.substring(pos, bestParameterMatcher.start())).append("{").append(parameter.getTypeName()).append("}");
        } while ((pos = bestParameterMatcher.start() + bestParameterMatcher.group().length()) < text.length());
        expression.append(text.substring(pos));
        return new GeneratedExpression(expression.toString(), parameterNames, parameters);
    }

    private String getParameterName(String typeName, Map<String, Integer> usageByTypeName) {
        Integer count = usageByTypeName.get(typeName);
        count = count != null ? count + 1 : 1;
        usageByTypeName.put(typeName, count);
        return count == 1 && !CucumberExpressionGenerator.isJavaKeyword(typeName) ? typeName : typeName + count;
    }

    private List<ParameterMatcher> createTransformMatchers(String text) {
        Collection<Parameter<?>> parameters = this.parameterRegistry.getParameters();
        ArrayList<ParameterMatcher> parameterMatchers = new ArrayList<ParameterMatcher>();
        for (Parameter<?> parameter : parameters) {
            parameterMatchers.addAll(this.createTransformMatchers(parameter, text));
        }
        return parameterMatchers;
    }

    private List<ParameterMatcher> createTransformMatchers(Parameter<?> parameter, String text) {
        ArrayList<ParameterMatcher> result = new ArrayList<ParameterMatcher>();
        List<String> captureGroupRegexps = parameter.getCaptureGroupRegexps();
        for (String captureGroupRegexp : captureGroupRegexps) {
            Pattern regexp = Pattern.compile("(" + captureGroupRegexp + ")");
            Matcher matcher = regexp.matcher(text);
            result.add(new ParameterMatcher(parameter, matcher, text.length()));
        }
        return result;
    }
}

