/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Transform;
import java.util.regex.Matcher;

class TransformMatcher
implements Comparable<TransformMatcher> {
    private final Transform<?> transform;
    private final Matcher matcher;
    private final int textLength;

    public TransformMatcher(Transform<?> transform, Matcher matcher, int textLength) {
        this.transform = transform;
        this.matcher = matcher;
        this.textLength = textLength;
    }

    public TransformMatcher advanceTo(int newMatchPos) {
        return new TransformMatcher(this.transform, this.matcher.region(newMatchPos, this.textLength), this.textLength);
    }

    public boolean find() {
        return this.matcher.find();
    }

    public int start() {
        return this.matcher.start();
    }

    public String group() {
        return this.matcher.group();
    }

    @Override
    public int compareTo(TransformMatcher o) {
        int posComparison = Integer.compare(this.start(), o.start());
        if (posComparison != 0) {
            return posComparison;
        }
        int lengthComparison = Integer.compare(o.group().length(), this.group().length());
        if (lengthComparison != 0) {
            return lengthComparison;
        }
        if (this.transform.getType().equals(Integer.TYPE)) {
            return -1;
        }
        if (this.transform.getType().equals(Double.TYPE)) {
            return -1;
        }
        return 0;
    }

    public Transform<?> getTransform() {
        return this.transform;
    }
}

