/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Argument;
import io.cucumber.cucumberexpressions.ArgumentMatcher;
import io.cucumber.cucumberexpressions.ClassTransform;
import io.cucumber.cucumberexpressions.ConstructorTransform;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.Transform;
import io.cucumber.cucumberexpressions.TransformLookup;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegularExpression
implements Expression {
    private static final Pattern CAPTURE_GROUP_PATTERN = Pattern.compile("\\(([^(]+)\\)");
    private final Pattern pattern;
    private final List<Transform<?>> transforms;

    public RegularExpression(Pattern pattern, List<? extends Type> types, TransformLookup transformLookup) {
        this.pattern = pattern;
        this.transforms = new ArrayList();
        Matcher matcher = CAPTURE_GROUP_PATTERN.matcher(pattern.pattern());
        int typeIndex = 0;
        while (matcher.find()) {
            Type type = types.size() <= typeIndex ? null : types.get(typeIndex++);
            String captureGroupPattern = matcher.group(1);
            Transform<String> transform = null;
            if (type != null) {
                transform = transformLookup.lookupByType(type);
            }
            if (transform == null) {
                transform = transformLookup.lookupByCaptureGroupRegexp(captureGroupPattern);
            }
            if (transform == null && type != null && type instanceof Class) {
                transform = new ClassTransform((Class)type);
            }
            if (transform == null) {
                transform = new ConstructorTransform<String>(String.class);
            }
            this.transforms.add(transform);
        }
    }

    @Override
    public List<Argument> match(String text) {
        return ArgumentMatcher.matchArguments(this.pattern, text, this.transforms);
    }

    @Override
    public String getSource() {
        return this.pattern.pattern();
    }
}

