/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.Function;
import io.cucumber.cucumberexpressions.NumberParser;
import io.cucumber.cucumberexpressions.SimpleTransform;
import io.cucumber.cucumberexpressions.Transform;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TransformLookup {
    private static final List<String> FIXNUM_REGEXPS = Arrays.asList("-?\\d+", "\\d+");
    private static final List<String> FLOATING_POINT_REGEXPS = Collections.singletonList("-?\\d*[\\.,]\\d+");
    private Map<Type, Transform<?>> transformsByType = new HashMap();
    private Map<String, Transform<?>> transformsByTypeName = new HashMap();
    private Map<String, Transform<?>> transformsByCaptureGroupRegexp = new HashMap();

    public TransformLookup(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        final NumberParser numberParser = new NumberParser(numberFormat);
        this.addTransform(new SimpleTransform<Byte>("byte", Byte.TYPE, FIXNUM_REGEXPS, new Function<String, Byte>(){

            @Override
            public Byte apply(String s) {
                return numberParser.parseByte(s);
            }
        }));
        this.addTransform(new SimpleTransform<Byte>("byte", Byte.class, FIXNUM_REGEXPS, new Function<String, Byte>(){

            @Override
            public Byte apply(String s) {
                return numberParser.parseByte(s);
            }
        }));
        this.addTransform(new SimpleTransform<Short>("short", Short.TYPE, FIXNUM_REGEXPS, new Function<String, Short>(){

            @Override
            public Short apply(String s) {
                return numberParser.parseShort(s);
            }
        }));
        this.addTransform(new SimpleTransform<Short>("short", Short.class, FIXNUM_REGEXPS, new Function<String, Short>(){

            @Override
            public Short apply(String s) {
                return numberParser.parseShort(s);
            }
        }));
        this.addTransform(new SimpleTransform<Integer>("int", Integer.TYPE, FIXNUM_REGEXPS, new Function<String, Integer>(){

            @Override
            public Integer apply(String s) {
                return numberParser.parseInt(s);
            }
        }));
        this.addTransform(new SimpleTransform<Integer>("int", Integer.class, FIXNUM_REGEXPS, new Function<String, Integer>(){

            @Override
            public Integer apply(String s) {
                return numberParser.parseInt(s);
            }
        }));
        this.addTransform(new SimpleTransform<Long>("long", Long.TYPE, FIXNUM_REGEXPS, new Function<String, Long>(){

            @Override
            public Long apply(String s) {
                return numberParser.parseLong(s);
            }
        }));
        this.addTransform(new SimpleTransform<Long>("long", Long.class, FIXNUM_REGEXPS, new Function<String, Long>(){

            @Override
            public Long apply(String s) {
                return numberParser.parseLong(s);
            }
        }));
        this.addTransform(new SimpleTransform<Float>("float", Float.TYPE, FLOATING_POINT_REGEXPS, new Function<String, Float>(){

            @Override
            public Float apply(String s) {
                return Float.valueOf(numberParser.parseFloat(s));
            }
        }));
        this.addTransform(new SimpleTransform<Float>("float", Float.class, FLOATING_POINT_REGEXPS, new Function<String, Float>(){

            @Override
            public Float apply(String s) {
                return Float.valueOf(numberParser.parseFloat(s));
            }
        }));
        this.addTransform(new SimpleTransform<Double>("double", Double.TYPE, FLOATING_POINT_REGEXPS, new Function<String, Double>(){

            @Override
            public Double apply(String s) {
                return numberParser.parseDouble(s);
            }
        }));
        this.addTransform(new SimpleTransform<Double>("double", Double.class, FLOATING_POINT_REGEXPS, new Function<String, Double>(){

            @Override
            public Double apply(String s) {
                return numberParser.parseDouble(s);
            }
        }));
    }

    public void addTransform(Transform<?> transform) {
        this.transformsByType.put(transform.getType(), transform);
        this.transformsByTypeName.put(transform.getTypeName(), transform);
        for (String captureGroupRegexp : transform.getCaptureGroupRegexps()) {
            this.transformsByCaptureGroupRegexp.put(captureGroupRegexp, transform);
        }
    }

    public <T> Transform<T> lookupByType(Type type) {
        return this.transformsByType.get(type);
    }

    public Transform<?> lookupByTypeName(String typeName, boolean ignoreUnknownTypeName) {
        Transform<?> transform = this.transformsByTypeName.get(typeName);
        if (transform == null) {
            if (ignoreUnknownTypeName) {
                return null;
            }
            throw new CucumberExpressionException(String.format("No transform for type name \"%s\"", typeName));
        }
        return transform;
    }

    public Transform lookupByCaptureGroupRegexp(String captureGroupPattern) {
        return this.transformsByCaptureGroupRegexp.get(captureGroupPattern);
    }

    public Collection<Transform<?>> getTransforms() {
        return this.transformsByType.values();
    }
}

