/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.Transform;
import io.cucumber.cucumberexpressions.TransformLookup;
import io.cucumber.cucumberexpressions.TransformMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CucumberExpressionGenerator {
    private final TransformLookup transformLookup;

    public CucumberExpressionGenerator(TransformLookup transformLookup) {
        this.transformLookup = transformLookup;
    }

    public GeneratedExpression generateExpression(String text, boolean typed) {
        TransformMatcher bestTransformMatcher;
        ArrayList<String> argumentNames = new ArrayList<String>();
        List<TransformMatcher> transformMatchers = this.createTransformMatchers(text);
        ArrayList transforms = new ArrayList();
        StringBuilder expression = new StringBuilder();
        int argCounter = 0;
        int pos = 0;
        do {
            ArrayList<TransformMatcher> matchingTransformMatchers = new ArrayList<TransformMatcher>();
            for (TransformMatcher transformMatcher : transformMatchers) {
                TransformMatcher advancedTransformMatcher = transformMatcher.advanceTo(pos);
                if (!advancedTransformMatcher.find()) continue;
                matchingTransformMatchers.add(advancedTransformMatcher);
            }
            if (matchingTransformMatchers.isEmpty()) break;
            String argumentName = "arg" + ++argCounter;
            argumentNames.add(argumentName);
            Collections.sort(matchingTransformMatchers);
            bestTransformMatcher = (TransformMatcher)matchingTransformMatchers.get(0);
            transforms.add(bestTransformMatcher.getTransform());
            expression.append(text.substring(pos, bestTransformMatcher.start())).append("{").append(argumentName);
            if (typed) {
                expression.append(":").append(bestTransformMatcher.getTransform().getTypeName());
            }
            expression.append("}");
        } while ((pos = bestTransformMatcher.start() + bestTransformMatcher.group().length()) < text.length());
        expression.append(text.substring(pos));
        return new GeneratedExpression(expression.toString(), argumentNames, transforms);
    }

    private List<TransformMatcher> createTransformMatchers(String text) {
        Collection<Transform<?>> transforms = this.transformLookup.getTransforms();
        ArrayList<TransformMatcher> transformMatchers = new ArrayList<TransformMatcher>();
        for (Transform<?> transform : transforms) {
            transformMatchers.addAll(this.createTransformMatchers(transform, text));
        }
        return transformMatchers;
    }

    private List<TransformMatcher> createTransformMatchers(Transform<?> transform, String text) {
        ArrayList<TransformMatcher> result = new ArrayList<TransformMatcher>();
        List<String> captureGroupRegexps = transform.getCaptureGroupRegexps();
        for (String captureGroupRegexp : captureGroupRegexps) {
            Pattern regexp = Pattern.compile("(" + captureGroupRegexp + ")");
            Matcher matcher = regexp.matcher(text);
            result.add(new TransformMatcher(transform, matcher, text.length()));
        }
        return result;
    }
}

