/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;

final class NiceAppendable
implements Appendable {
    private static final CharSequence NL = "\n";
    private final Appendable out;
    private final boolean flushEveryWrite;

    public NiceAppendable(Appendable out) {
        this(out, false);
    }

    public NiceAppendable(Appendable out, boolean flushEveryWrite) {
        this.out = out;
        this.flushEveryWrite = flushEveryWrite;
    }

    public NiceAppendable println() {
        return this.append(NL);
    }

    @Override
    public NiceAppendable append(CharSequence csq) {
        try {
            this.out.append(csq);
            this.tryFlush();
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NiceAppendable append(CharSequence csq, int start, int end) {
        try {
            this.out.append(csq, start, end);
            this.tryFlush();
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NiceAppendable append(char c) {
        try {
            this.out.append(c);
            this.tryFlush();
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void tryFlush() {
        if (!(this.out instanceof Flushable)) {
            return;
        }
        if (!this.flushEveryWrite) {
            return;
        }
        try {
            ((Flushable)((Object)this.out)).flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NiceAppendable println(CharSequence csq) {
        try {
            this.out.append(csq).append(NL);
            this.tryFlush();
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.tryFlush();
            if (this.out instanceof Closeable) {
                ((Closeable)((Object)this.out)).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

