/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.messages.types.Envelope;
import io.cucumber.plugin.ColorAware;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.prettyformatter.MessagesToSummaryWriter;
import io.cucumber.prettyformatter.Theme;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public final class DefaultSummaryPrinter
implements ColorAware,
ConcurrentEventListener {
    private final OutputStream out;
    private MessagesToSummaryWriter writer;

    public DefaultSummaryPrinter() {
        this(new PrintStream(System.out){

            @Override
            public void close() {
            }
        });
    }

    DefaultSummaryPrinter(OutputStream out) {
        this.out = out;
        this.writer = DefaultSummaryPrinter.createBuilder().build(out);
    }

    private static MessagesToSummaryWriter.Builder createBuilder() {
        return MessagesToSummaryWriter.builder().theme(Theme.cucumber());
    }

    public void setMonochrome(boolean monochrome) {
        if (monochrome) {
            this.writer = DefaultSummaryPrinter.createBuilder().theme(Theme.plain()).build(this.out);
        }
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Envelope.class, this::write);
    }

    private void write(Envelope event) {
        try {
            this.writer.write(event);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (event.getTestRunFinished().isPresent()) {
            this.writer.close();
        }
    }
}

