/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.plugin.ColorAware;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

public final class ProgressFormatter
implements ConcurrentEventListener,
ColorAware {
    private static final int MAX_WIDTH = 80;
    private static final Map<TestStepResultStatus, String> SYMBOLS = new EnumMap<TestStepResultStatus, String>(TestStepResultStatus.class);
    private static final Map<TestStepResultStatus, Ansi> ESCAPES = new EnumMap<TestStepResultStatus, Ansi>(TestStepResultStatus.class);
    private static final Ansi RESET = Ansi.with(Ansi.Attributes.FOREGROUND_DEFAULT);
    private final PrintWriter writer;
    private boolean monochrome = false;
    private int width = 0;

    public ProgressFormatter(OutputStream out) {
        this.writer = ProgressFormatter.createPrintWriter(out);
    }

    private static PrintWriter createPrintWriter(OutputStream out) {
        return new PrintWriter(new OutputStreamWriter(Objects.requireNonNull(out), StandardCharsets.UTF_8));
    }

    public void setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Envelope.class, event -> {
            event.getTestStepFinished().ifPresent(this::handleTestStepFinished);
            event.getTestRunFinished().ifPresent(this::handleTestRunFinished);
        });
    }

    private void handleTestStepFinished(TestStepFinished event) {
        TestStepResultStatus status = event.getTestStepResult().getStatus();
        StringBuilder buffer = new StringBuilder();
        if (!this.monochrome) {
            buffer.append(ESCAPES.get(status));
        }
        buffer.append(SYMBOLS.get(status));
        if (!this.monochrome) {
            buffer.append(RESET);
        }
        if (++this.width % 80 == 0) {
            this.width = 0;
            buffer.append(System.lineSeparator());
        }
        this.writer.append(buffer);
        this.writer.flush();
    }

    private void handleTestRunFinished(TestRunFinished testRunFinished) {
        this.writer.println();
        this.writer.close();
    }

    static {
        SYMBOLS.put(TestStepResultStatus.PASSED, ".");
        SYMBOLS.put(TestStepResultStatus.UNDEFINED, "U");
        SYMBOLS.put(TestStepResultStatus.PENDING, "P");
        SYMBOLS.put(TestStepResultStatus.SKIPPED, "-");
        SYMBOLS.put(TestStepResultStatus.FAILED, "F");
        SYMBOLS.put(TestStepResultStatus.AMBIGUOUS, "A");
        ESCAPES.put(TestStepResultStatus.PASSED, Ansi.with(Ansi.Attributes.FOREGROUND_GREEN));
        ESCAPES.put(TestStepResultStatus.UNDEFINED, Ansi.with(Ansi.Attributes.FOREGROUND_YELLOW));
        ESCAPES.put(TestStepResultStatus.PENDING, Ansi.with(Ansi.Attributes.FOREGROUND_YELLOW));
        ESCAPES.put(TestStepResultStatus.SKIPPED, Ansi.with(Ansi.Attributes.FOREGROUND_CYAN));
        ESCAPES.put(TestStepResultStatus.FAILED, Ansi.with(Ansi.Attributes.FOREGROUND_RED));
        ESCAPES.put(TestStepResultStatus.AMBIGUOUS, Ansi.with(Ansi.Attributes.FOREGROUND_RED));
    }

    static final class Ansi {
        private static final char FIRST_ESCAPE = '\u001b';
        private static final char SECOND_ESCAPE = '[';
        private static final String END_SEQUENCE = "m";
        private final String controlSequence;

        public static Ansi with(Attributes ... attributes) {
            return new Ansi(Objects.requireNonNull(attributes));
        }

        private Ansi(Attributes ... attributes) {
            this.controlSequence = this.createControlSequence(attributes);
        }

        private String createControlSequence(Attributes ... attributes) {
            StringBuilder a = new StringBuilder(attributes.length * 5);
            for (Attributes attribute : attributes) {
                a.append('\u001b').append('[');
                a.append(attribute.value);
                a.append(END_SEQUENCE);
            }
            return a.toString();
        }

        public String toString() {
            return this.controlSequence;
        }

        static enum Attributes {
            FOREGROUND_RED(31),
            FOREGROUND_GREEN(32),
            FOREGROUND_YELLOW(33),
            FOREGROUND_CYAN(36),
            FOREGROUND_DEFAULT(39);

            private final int value;

            private Attributes(int index) {
                this.value = index;
            }
        }
    }
}

