/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.options.PluginOption;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.order.PickleOrder;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.snippets.SnippetType;
import io.cucumber.tagexpressions.Expression;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public final class RuntimeOptionsBuilder {
    private final List<Expression> parsedTagFilters = new ArrayList<Expression>();
    private final List<Pattern> parsedNameFilters = new ArrayList<Pattern>();
    private final List<FeatureWithLines> parsedFeaturePaths = new ArrayList<FeatureWithLines>();
    private final List<URI> parsedGlue = new ArrayList<URI>();
    private final List<Options.Plugin> formatters = new ArrayList<Options.Plugin>();
    private final List<Options.Plugin> summaryPrinters = new ArrayList<Options.Plugin>();
    private List<FeatureWithLines> parsedRerunPaths = null;
    private Integer parsedThreads = null;
    private Boolean parsedDryRun = null;
    private Boolean parsedMonochrome = null;
    private SnippetType parsedSnippetType = null;
    private Boolean parsedWip = null;
    private PickleOrder parsedPickleOrder = null;
    private Integer parsedCount = null;
    private Class<? extends ObjectFactory> parsedObjectFactoryClass = null;
    private boolean addDefaultSummaryPrinterIfAbsent;
    private boolean addDefaultFormatterIfAbsent;
    private boolean addDefaultGlueIfAbsent;
    private boolean addDefaultFeaturePathIfAbsent;

    public RuntimeOptionsBuilder addRerun(Collection<FeatureWithLines> featureWithLines) {
        if (this.parsedRerunPaths == null) {
            this.parsedRerunPaths = new ArrayList<FeatureWithLines>();
        }
        this.parsedRerunPaths.addAll(featureWithLines);
        return this;
    }

    public RuntimeOptionsBuilder addFeature(FeatureWithLines featureWithLines) {
        this.parsedFeaturePaths.add(featureWithLines);
        return this;
    }

    public RuntimeOptionsBuilder addGlue(URI glue) {
        this.parsedGlue.add(glue);
        return this;
    }

    public RuntimeOptionsBuilder addNameFilter(Pattern pattern) {
        this.parsedNameFilters.add(pattern);
        return this;
    }

    public RuntimeOptionsBuilder addPluginName(String pluginSpecification) {
        PluginOption pluginOption = PluginOption.parse(pluginSpecification);
        if (pluginOption.isSummaryPrinter()) {
            this.summaryPrinters.add(pluginOption);
        } else if (pluginOption.isFormatter()) {
            this.formatters.add(pluginOption);
        } else {
            throw new CucumberException("Unrecognized plugin: " + pluginSpecification);
        }
        return this;
    }

    public RuntimeOptionsBuilder addTagFilter(Expression tagExpression) {
        this.parsedTagFilters.add(tagExpression);
        return this;
    }

    public RuntimeOptions build() {
        return this.build(RuntimeOptions.defaultOptions());
    }

    public RuntimeOptions build(RuntimeOptions runtimeOptions) {
        if (this.parsedThreads != null) {
            runtimeOptions.setThreads(this.parsedThreads);
        }
        if (this.parsedDryRun != null) {
            runtimeOptions.setDryRun(this.parsedDryRun);
        }
        if (this.parsedMonochrome != null) {
            runtimeOptions.setMonochrome(this.parsedMonochrome);
        }
        if (this.parsedSnippetType != null) {
            runtimeOptions.setSnippetType(this.parsedSnippetType);
        }
        if (this.parsedWip != null) {
            runtimeOptions.setWip(this.parsedWip);
        }
        if (this.parsedPickleOrder != null) {
            runtimeOptions.setPickleOrder(this.parsedPickleOrder);
        }
        if (this.parsedCount != null) {
            runtimeOptions.setCount(this.parsedCount);
        }
        if (!this.parsedTagFilters.isEmpty() || !this.parsedNameFilters.isEmpty() || this.hasFeaturesWithLineFilters()) {
            runtimeOptions.setTagExpressions(this.parsedTagFilters);
            runtimeOptions.setNameFilters(this.parsedNameFilters);
        }
        if (!this.parsedFeaturePaths.isEmpty() || this.parsedRerunPaths != null) {
            ArrayList<FeatureWithLines> features = new ArrayList<FeatureWithLines>(this.parsedFeaturePaths);
            if (this.parsedRerunPaths != null) {
                features.addAll(this.parsedRerunPaths);
            }
            runtimeOptions.setFeaturePaths(features);
        }
        if (!this.parsedGlue.isEmpty()) {
            runtimeOptions.setGlue(this.parsedGlue);
        }
        runtimeOptions.addFormatters(this.formatters);
        runtimeOptions.addSummaryPrinters(this.summaryPrinters);
        if (this.parsedObjectFactoryClass != null) {
            runtimeOptions.setObjectFactoryClass(this.parsedObjectFactoryClass);
        }
        if (this.addDefaultFormatterIfAbsent) {
            runtimeOptions.addDefaultFormatterIfAbsent();
        }
        if (this.addDefaultSummaryPrinterIfAbsent) {
            runtimeOptions.addDefaultSummaryPrinterIfAbsent();
        }
        if (this.addDefaultGlueIfAbsent) {
            runtimeOptions.addDefaultGlueIfAbsent();
        }
        if (this.addDefaultFeaturePathIfAbsent) {
            runtimeOptions.addDefaultFeaturePathIfAbsent();
        }
        return runtimeOptions;
    }

    private boolean hasFeaturesWithLineFilters() {
        return this.parsedRerunPaths != null || !this.parsedFeaturePaths.stream().map(FeatureWithLines::lines).allMatch(Set::isEmpty);
    }

    public RuntimeOptionsBuilder setCount(int count) {
        this.parsedCount = count;
        return this;
    }

    public RuntimeOptionsBuilder setDryRun() {
        return this.setDryRun(true);
    }

    public RuntimeOptionsBuilder setDryRun(boolean dryRun) {
        this.parsedDryRun = dryRun;
        return this;
    }

    public RuntimeOptionsBuilder setMonochrome() {
        return this.setMonochrome(true);
    }

    public RuntimeOptionsBuilder setMonochrome(boolean monochrome) {
        this.parsedMonochrome = monochrome;
        return this;
    }

    public RuntimeOptionsBuilder setPickleOrder(PickleOrder pickleOrder) {
        this.parsedPickleOrder = pickleOrder;
        return this;
    }

    public RuntimeOptionsBuilder setSnippetType(SnippetType snippetType) {
        this.parsedSnippetType = snippetType;
        return this;
    }

    public RuntimeOptionsBuilder setThreads(int threads) {
        this.parsedThreads = threads;
        return this;
    }

    public RuntimeOptionsBuilder setWip(boolean wip) {
        this.parsedWip = wip;
        return this;
    }

    public RuntimeOptionsBuilder addDefaultSummaryPrinterIfAbsent() {
        this.addDefaultSummaryPrinterIfAbsent = true;
        return this;
    }

    public RuntimeOptionsBuilder addDefaultFormatterIfAbsent() {
        this.addDefaultFormatterIfAbsent = true;
        return this;
    }

    public RuntimeOptionsBuilder addDefaultGlueIfAbsent() {
        this.addDefaultGlueIfAbsent = true;
        return this;
    }

    public RuntimeOptionsBuilder addDefaultFeaturePathIfAbsent() {
        this.addDefaultFeaturePathIfAbsent = true;
        return this;
    }

    public void setObjectFactoryClass(Class<? extends ObjectFactory> objectFactoryClass) {
        this.parsedObjectFactoryClass = objectFactoryClass;
    }
}

