/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.resource;

import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.resource.CloseablePath;
import io.cucumber.core.resource.JarUriFileSystemService;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

class PathScanner {
    PathScanner() {
    }

    void findResourcesForUri(URI baseUri, Predicate<Path> filter, Function<Path, Consumer<Path>> consumer) {
        try (CloseablePath closeablePath = this.open(baseUri);){
            Path baseDir = closeablePath.getPath();
            this.findResourcesForPath(baseDir, filter, consumer);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private CloseablePath open(URI uri) throws IOException, URISyntaxException {
        if (JarUriFileSystemService.supports(uri)) {
            return JarUriFileSystemService.open(uri);
        }
        return CloseablePath.open(uri);
    }

    void findResourcesForPath(Path path, Predicate<Path> filter, Function<Path, Consumer<Path>> consumer) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("path must exist: " + path);
        }
        try {
            Files.walkFileTree(path, new ResourceFileVisitor(filter, consumer.apply(path)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class ResourceFileVisitor
    extends SimpleFileVisitor<Path> {
        private static final Logger logger = LoggerFactory.getLogger(ResourceFileVisitor.class);
        private final Predicate<Path> resourceFileFilter;
        private final Consumer<Path> resourceFileConsumer;

        ResourceFileVisitor(Predicate<Path> resourceFileFilter, Consumer<Path> resourceFileConsumer) {
            this.resourceFileFilter = resourceFileFilter;
            this.resourceFileConsumer = resourceFileConsumer;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
            if (this.resourceFileFilter.test(file)) {
                this.resourceFileConsumer.accept(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) {
            logger.warn(e, () -> "IOException visiting file: " + file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException e) {
            if (e != null) {
                logger.warn(e, () -> "IOException visiting directory: " + dir);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

