/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.exception.CompositeCucumberException;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.runner.Runner;
import io.cucumber.core.runtime.ExitStatus;
import io.cucumber.core.runtime.Meta;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.messages.Messages;
import io.cucumber.messages.TimeConversion;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceRead;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public final class CucumberExecutionContext {
    private static final Logger log = LoggerFactory.getLogger(CucumberExecutionContext.class);
    private final EventBus bus;
    private final ExitStatus exitStatus;
    private final RunnerSupplier runnerSupplier;
    private final List<Throwable> thrown = Collections.synchronizedList(new ArrayList());
    private Instant start;

    public CucumberExecutionContext(EventBus bus, ExitStatus exitStatus, RunnerSupplier runnerSupplier) {
        this.bus = bus;
        this.exitStatus = exitStatus;
        this.runnerSupplier = runnerSupplier;
    }

    public void emitMeta() {
        this.bus.send(Messages.Envelope.newBuilder().setMeta(Meta.makeMeta()).build());
    }

    public void startTestRun() {
        log.debug(() -> "Sending run test started event");
        this.start = this.bus.getInstant();
        this.bus.send(new TestRunStarted(this.start));
        this.bus.send(Messages.Envelope.newBuilder().setTestRunStarted(Messages.TestRunStarted.newBuilder().setTimestamp(TimeConversion.javaInstantToTimestamp((Instant)this.start))).build());
    }

    public void finishTestRun() {
        log.debug(() -> "Sending test run finished event");
        CucumberException cucumberException = this.getException();
        this.emitTestRunFinished(cucumberException);
    }

    public CucumberException getException() {
        if (this.thrown.isEmpty()) {
            return null;
        }
        if (this.thrown.size() == 1) {
            return new CucumberException(this.thrown.get(0));
        }
        return new CompositeCucumberException(this.thrown);
    }

    private void emitTestRunFinished(CucumberException cucumberException) {
        Instant instant = this.bus.getInstant();
        Result result = new Result(cucumberException != null ? Status.FAILED : this.exitStatus.getStatus(), Duration.between(this.start, instant), (Throwable)cucumberException);
        this.bus.send(new TestRunFinished(instant, result));
        Messages.TestRunFinished.Builder testRunFinished = Messages.TestRunFinished.newBuilder().setSuccess(this.exitStatus.isSuccess()).setTimestamp(TimeConversion.javaInstantToTimestamp((Instant)instant));
        if (cucumberException != null) {
            testRunFinished.setMessage(cucumberException.getMessage());
        }
        this.bus.send(Messages.Envelope.newBuilder().setTestRunFinished(testRunFinished).build());
    }

    public void beforeFeature(Feature feature) {
        log.debug(() -> "Sending test source read event for " + feature.getUri());
        this.bus.send(new TestSourceRead(this.bus.getInstant(), feature.getUri(), feature.getSource()));
        this.bus.sendAll(feature.getParseEvents());
    }

    public void runTestCase(Consumer<Runner> execution) {
        Runner runner = this.getRunner();
        try {
            execution.accept(runner);
        }
        catch (Throwable e) {
            this.thrown.add(e);
            throw e;
        }
    }

    private Runner getRunner() {
        try {
            return this.runnerSupplier.get();
        }
        catch (Throwable e) {
            log.error(e, () -> "Unable to start Cucumber");
            this.thrown.add(e);
            throw e;
        }
    }
}

