/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.Pending;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.runner.AmbiguousStepDefinitionsException;
import io.cucumber.core.runner.StepDefinitionMatch;
import io.cucumber.core.runner.TestCaseState;
import io.cucumber.core.runner.TestStepResultStatus;
import io.cucumber.core.runner.UndefinedStepDefinitionException;
import io.cucumber.messages.Messages;
import io.cucumber.messages.TimeConversion;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;

abstract class TestStep
implements io.cucumber.plugin.event.TestStep {
    private static final String[] ASSUMPTION_VIOLATED_EXCEPTIONS = new String[]{"org.junit.AssumptionViolatedException", "org.junit.internal.AssumptionViolatedException", "org.opentest4j.TestAbortedException", "org.testng.SkipException"};
    private final StepDefinitionMatch stepDefinitionMatch;
    private final UUID id;

    TestStep(UUID id, StepDefinitionMatch stepDefinitionMatch) {
        this.id = id;
        this.stepDefinitionMatch = stepDefinitionMatch;
    }

    public UUID getId() {
        return this.id;
    }

    public String getCodeLocation() {
        return this.stepDefinitionMatch.getCodeLocation();
    }

    boolean run(TestCase testCase, EventBus bus, TestCaseState state, boolean skipSteps) {
        Status status;
        Instant startTime = bus.getInstant();
        this.emitTestStepStarted(testCase, bus, state.getTestExecutionId(), startTime);
        Throwable error = null;
        try {
            status = this.executeStep(state, skipSteps);
        }
        catch (Throwable t) {
            error = t;
            status = this.mapThrowableToStatus(t);
        }
        Instant stopTime = bus.getInstant();
        Duration duration = Duration.between(startTime, stopTime);
        Result result = this.mapStatusToResult(status, error, duration);
        state.add(result);
        this.emitTestStepFinished(testCase, bus, state.getTestExecutionId(), stopTime, duration, result);
        return !result.getStatus().is(Status.PASSED);
    }

    private void emitTestStepStarted(TestCase testCase, EventBus bus, UUID textExecutionId, Instant startTime) {
        bus.send(new TestStepStarted(startTime, testCase, (io.cucumber.plugin.event.TestStep)this));
        bus.send(Messages.Envelope.newBuilder().setTestStepStarted(Messages.TestStepStarted.newBuilder().setTestCaseStartedId(textExecutionId.toString()).setTestStepId(this.id.toString()).setTimestamp(TimeConversion.javaInstantToTimestamp((Instant)startTime))).build());
    }

    private void emitTestStepFinished(TestCase testCase, EventBus bus, UUID textExecutionId, Instant stopTime, Duration duration, Result result) {
        bus.send(new TestStepFinished(stopTime, testCase, (io.cucumber.plugin.event.TestStep)this, result));
        Messages.TestStepFinished.TestStepResult.Builder builder = Messages.TestStepFinished.TestStepResult.newBuilder();
        if (result.getError() != null) {
            builder.setMessage(this.extractStackTrace(result.getError()));
        }
        Messages.TestStepFinished.TestStepResult testResult = builder.setStatus(TestStepResultStatus.from(result.getStatus())).setDuration(TimeConversion.javaDurationToDuration((Duration)duration)).build();
        bus.send(Messages.Envelope.newBuilder().setTestStepFinished(Messages.TestStepFinished.newBuilder().setTestCaseStartedId(textExecutionId.toString()).setTestStepId(this.id.toString()).setTimestamp(TimeConversion.javaInstantToTimestamp((Instant)stopTime)).setTestStepResult(testResult)).build());
    }

    private String extractStackTrace(Throwable error) {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(s);
        error.printStackTrace(printStream);
        return new String(s.toByteArray(), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status executeStep(TestCaseState state, boolean skipSteps) throws Throwable {
        state.setCurrentTestStepId(this.id);
        try {
            if (!skipSteps) {
                this.stepDefinitionMatch.runStep(state);
                Status status = Status.PASSED;
                return status;
            }
            this.stepDefinitionMatch.dryRunStep(state);
            Status status = Status.SKIPPED;
            return status;
        }
        finally {
            state.clearCurrentTestStepId();
        }
    }

    private Status mapThrowableToStatus(Throwable t) {
        if (t.getClass().isAnnotationPresent(Pending.class)) {
            return Status.PENDING;
        }
        if (Arrays.binarySearch(ASSUMPTION_VIOLATED_EXCEPTIONS, t.getClass().getName()) >= 0) {
            return Status.SKIPPED;
        }
        if (t.getClass() == UndefinedStepDefinitionException.class) {
            return Status.UNDEFINED;
        }
        if (t.getClass() == AmbiguousStepDefinitionsException.class) {
            return Status.AMBIGUOUS;
        }
        return Status.FAILED;
    }

    private Result mapStatusToResult(Status status, Throwable error, Duration duration) {
        if (status == Status.UNDEFINED) {
            return new Result(status, Duration.ZERO, null);
        }
        return new Result(status, duration, error);
    }

    static {
        Arrays.sort(ASSUMPTION_VIOLATED_EXCEPTIONS);
    }
}

