/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.exception.ExceptionUtils;
import io.cucumber.core.plugin.TestSourcesModel;
import io.cucumber.messages.Messages;
import io.cucumber.messages.internal.com.google.gson.Gson;
import io.cucumber.messages.internal.com.google.gson.GsonBuilder;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.event.Argument;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.DocStringArgument;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.HookType;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public final class JsonFormatter
implements EventListener {
    private static final String before = "before";
    private static final String after = "after";
    private URI currentFeatureFile;
    private final List<Map<String, Object>> featureMaps = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> currentElementsList;
    private Map<String, Object> currentElementMap;
    private Map<String, Object> currentTestCaseMap;
    private List<Map<String, Object>> currentStepsList;
    private Map<String, Object> currentStepOrHookMap;
    private final Map<String, Object> currentBeforeStepHookList = new HashMap<String, Object>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final OutputStreamWriter out;
    private final TestSourcesModel testSources = new TestSourcesModel();

    public JsonFormatter(OutputStream out) {
        this.out = new OutputStreamWriter(out, StandardCharsets.UTF_8);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this::handleTestSourceRead);
        publisher.registerHandlerFor(TestCaseStarted.class, this::handleTestCaseStarted);
        publisher.registerHandlerFor(TestStepStarted.class, this::handleTestStepStarted);
        publisher.registerHandlerFor(TestStepFinished.class, this::handleTestStepFinished);
        publisher.registerHandlerFor(WriteEvent.class, this::handleWrite);
        publisher.registerHandlerFor(EmbedEvent.class, this::handleEmbed);
        publisher.registerHandlerFor(TestRunFinished.class, this::finishReport);
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.getUri(), event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        if (this.currentFeatureFile == null || !this.currentFeatureFile.equals(event.getTestCase().getUri())) {
            this.currentFeatureFile = event.getTestCase().getUri();
            Map<String, Object> currentFeatureMap = this.createFeatureMap(event.getTestCase());
            this.featureMaps.add(currentFeatureMap);
            this.currentElementsList = (List)currentFeatureMap.get("elements");
        }
        this.currentTestCaseMap = this.createTestCase(event);
        if (this.testSources.hasBackground(this.currentFeatureFile, event.getTestCase().getLine())) {
            this.currentElementMap = this.createBackground(event.getTestCase());
            this.currentElementsList.add(this.currentElementMap);
        } else {
            this.currentElementMap = this.currentTestCaseMap;
        }
        this.currentElementsList.add(this.currentTestCaseMap);
        this.currentStepsList = (List)this.currentElementMap.get("steps");
    }

    private void handleTestStepStarted(TestStepStarted event) {
        if (event.getTestStep() instanceof PickleStepTestStep) {
            PickleStepTestStep testStep = (PickleStepTestStep)event.getTestStep();
            if (this.isFirstStepAfterBackground(testStep)) {
                this.currentElementMap = this.currentTestCaseMap;
                this.currentStepsList = (List)this.currentElementMap.get("steps");
            }
            this.currentStepOrHookMap = this.createTestStep(testStep);
            if (this.currentBeforeStepHookList.containsKey(before)) {
                this.currentStepOrHookMap.put(before, this.currentBeforeStepHookList.get(before));
                this.currentBeforeStepHookList.clear();
            }
            this.currentStepsList.add(this.currentStepOrHookMap);
        } else if (event.getTestStep() instanceof HookTestStep) {
            HookTestStep hookTestStep = (HookTestStep)event.getTestStep();
            this.currentStepOrHookMap = this.createHookStep(hookTestStep);
            this.addHookStepToTestCaseMap(this.currentStepOrHookMap, hookTestStep.getHookType());
        } else {
            throw new IllegalStateException();
        }
    }

    private void handleWrite(WriteEvent event) {
        this.addOutputToHookMap(event.getText());
    }

    private void handleEmbed(EmbedEvent event) {
        this.addEmbeddingToHookMap(event.getData(), event.getMediaType(), event.getName());
    }

    private void handleTestStepFinished(TestStepFinished event) {
        this.currentStepOrHookMap.put("match", this.createMatchMap(event.getTestStep(), event.getResult()));
        this.currentStepOrHookMap.put("result", this.createResultMap(event.getResult()));
    }

    private void finishReport(TestRunFinished event) {
        Throwable exception = event.getResult().getError();
        if (exception != null) {
            LinkedHashMap<String, Object> feature = new LinkedHashMap<String, Object>();
            feature.put("description", "Test run failed");
            LinkedHashMap<String, Object> elements = new LinkedHashMap<String, Object>();
            feature.put("elements", elements);
            elements.put("description", "There were errors during the execution");
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            elements.put("result", result);
            result.put("error_message", exception.getMessage());
            result.put("status", "failed");
            this.featureMaps.add(feature);
        }
        this.gson.toJson(this.featureMaps, (Appendable)this.out);
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> createFeatureMap(TestCase testCase) {
        HashMap<String, Object> featureMap = new HashMap<String, Object>();
        featureMap.put("uri", TestSourcesModel.relativize(testCase.getUri()));
        featureMap.put("elements", new ArrayList());
        Messages.GherkinDocument.Feature feature = this.testSources.getFeature(testCase.getUri());
        if (feature != null) {
            featureMap.put("keyword", feature.getKeyword());
            featureMap.put("name", feature.getName());
            featureMap.put("description", feature.getDescription() != null ? feature.getDescription() : "");
            featureMap.put("line", feature.getLocation().getLine());
            featureMap.put("id", TestSourcesModel.convertToId(feature.getName()));
            featureMap.put("tags", feature.getTagsList().stream().map(tag -> {
                LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
                json.put("name", tag.getName());
                json.put("type", "Tag");
                LinkedHashMap<String, Integer> location = new LinkedHashMap<String, Integer>();
                location.put("line", tag.getLocation().getLine());
                location.put("column", tag.getLocation().getColumn());
                json.put("location", location);
                return json;
            }).collect(Collectors.toList()));
        }
        return featureMap;
    }

    private Map<String, Object> createTestCase(TestCaseStarted event) {
        HashMap<String, Object> testCaseMap = new HashMap<String, Object>();
        testCaseMap.put("start_timestamp", this.getDateTimeFromTimeStamp(event.getInstant()));
        TestCase testCase = event.getTestCase();
        testCaseMap.put("name", testCase.getName());
        testCaseMap.put("line", testCase.getLine());
        testCaseMap.put("type", "scenario");
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (astNode != null) {
            testCaseMap.put("id", TestSourcesModel.calculateId(astNode));
            Messages.GherkinDocument.Feature.Scenario scenarioDefinition = TestSourcesModel.getScenarioDefinition(astNode);
            testCaseMap.put("keyword", scenarioDefinition.getKeyword());
            testCaseMap.put("description", scenarioDefinition.getDescription() != null ? scenarioDefinition.getDescription() : "");
        }
        testCaseMap.put("steps", new ArrayList());
        if (!testCase.getTags().isEmpty()) {
            ArrayList tagList = new ArrayList();
            for (String tag : testCase.getTags()) {
                HashMap<String, String> tagMap = new HashMap<String, String>();
                tagMap.put("name", tag);
                tagList.add(tagMap);
            }
            testCaseMap.put("tags", tagList);
        }
        return testCaseMap;
    }

    private Map<String, Object> createBackground(TestCase testCase) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (astNode != null) {
            Messages.GherkinDocument.Feature.Background background = TestSourcesModel.getBackgroundForTestCase(astNode);
            HashMap<String, Object> testCaseMap = new HashMap<String, Object>();
            testCaseMap.put("name", background.getName());
            testCaseMap.put("line", background.getLocation().getLine());
            testCaseMap.put("type", "background");
            testCaseMap.put("keyword", background.getKeyword());
            testCaseMap.put("description", background.getDescription() != null ? background.getDescription() : "");
            testCaseMap.put("steps", new ArrayList());
            return testCaseMap;
        }
        return null;
    }

    private boolean isFirstStepAfterBackground(PickleStepTestStep testStep) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine());
        if (astNode == null) {
            return false;
        }
        return this.currentElementMap != this.currentTestCaseMap && !TestSourcesModel.isBackgroundStep(astNode);
    }

    private Map<String, Object> createTestStep(PickleStepTestStep testStep) {
        HashMap<String, Object> stepMap = new HashMap<String, Object>();
        stepMap.put("name", testStep.getStepText());
        stepMap.put("line", testStep.getStepLine());
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine());
        StepArgument argument = testStep.getStepArgument();
        if (argument != null) {
            if (argument instanceof DocStringArgument) {
                DocStringArgument docStringArgument = (DocStringArgument)argument;
                stepMap.put("doc_string", this.createDocStringMap(docStringArgument));
            } else if (argument instanceof DataTableArgument) {
                DataTableArgument dataTableArgument = (DataTableArgument)argument;
                stepMap.put("rows", this.createDataTableList(dataTableArgument));
            }
        }
        if (astNode != null) {
            Messages.GherkinDocument.Feature.Step step = (Messages.GherkinDocument.Feature.Step)astNode.node;
            stepMap.put("keyword", step.getKeyword());
        }
        return stepMap;
    }

    private Map<String, Object> createDocStringMap(DocStringArgument docString) {
        HashMap<String, Object> docStringMap = new HashMap<String, Object>();
        docStringMap.put("value", docString.getContent());
        docStringMap.put("line", docString.getLine());
        docStringMap.put("content_type", docString.getMediaType());
        return docStringMap;
    }

    private List<Map<String, List<String>>> createDataTableList(DataTableArgument argument) {
        ArrayList<Map<String, List<String>>> rowList = new ArrayList<Map<String, List<String>>>();
        for (List row : argument.cells()) {
            HashMap rowMap = new HashMap();
            rowMap.put("cells", new ArrayList(row));
            rowList.add(rowMap);
        }
        return rowList;
    }

    private Map<String, Object> createHookStep(HookTestStep hookTestStep) {
        return new HashMap<String, Object>();
    }

    private void addHookStepToTestCaseMap(Map<String, Object> currentStepOrHookMap, HookType hookType) {
        Map<String, Object> mapToAddTo;
        String hookName = hookType == HookType.AFTER || hookType == HookType.AFTER_STEP ? after : before;
        switch (hookType) {
            case BEFORE: {
                mapToAddTo = this.currentTestCaseMap;
                break;
            }
            case AFTER: {
                mapToAddTo = this.currentTestCaseMap;
                break;
            }
            case BEFORE_STEP: {
                mapToAddTo = this.currentBeforeStepHookList;
                break;
            }
            case AFTER_STEP: {
                mapToAddTo = this.currentStepsList.get(this.currentStepsList.size() - 1);
                break;
            }
            default: {
                mapToAddTo = this.currentTestCaseMap;
            }
        }
        if (!mapToAddTo.containsKey(hookName)) {
            mapToAddTo.put(hookName, new ArrayList());
        }
        ((List)mapToAddTo.get(hookName)).add(currentStepOrHookMap);
    }

    private void addOutputToHookMap(String text) {
        if (!this.currentStepOrHookMap.containsKey("output")) {
            this.currentStepOrHookMap.put("output", new ArrayList());
        }
        ((List)this.currentStepOrHookMap.get("output")).add(text);
    }

    private void addEmbeddingToHookMap(byte[] data, String mediaType, String name) {
        if (!this.currentStepOrHookMap.containsKey("embeddings")) {
            this.currentStepOrHookMap.put("embeddings", new ArrayList());
        }
        Map<String, Object> embedMap = this.createEmbeddingMap(data, mediaType, name);
        ((List)this.currentStepOrHookMap.get("embeddings")).add(embedMap);
    }

    private Map<String, Object> createEmbeddingMap(byte[] data, String mediaType, String name) {
        HashMap<String, Object> embedMap = new HashMap<String, Object>();
        embedMap.put("mime_type", mediaType);
        embedMap.put("data", Base64.getEncoder().encodeToString(data));
        if (name != null) {
            embedMap.put("name", name);
        }
        return embedMap;
    }

    private Map<String, Object> createMatchMap(TestStep step, Result result) {
        PickleStepTestStep testStep;
        HashMap<String, Object> matchMap = new HashMap<String, Object>();
        if (step instanceof PickleStepTestStep && !(testStep = (PickleStepTestStep)step).getDefinitionArgument().isEmpty()) {
            ArrayList argumentList = new ArrayList();
            for (Argument argument : testStep.getDefinitionArgument()) {
                HashMap<String, Object> argumentMap = new HashMap<String, Object>();
                if (argument.getValue() != null) {
                    argumentMap.put("val", argument.getValue());
                    argumentMap.put("offset", argument.getStart());
                }
                argumentList.add(argumentMap);
            }
            matchMap.put("arguments", argumentList);
        }
        if (!result.getStatus().is(Status.UNDEFINED)) {
            matchMap.put("location", step.getCodeLocation());
        }
        return matchMap;
    }

    private Map<String, Object> createResultMap(Result result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("status", result.getStatus().name().toLowerCase(Locale.ROOT));
        if (result.getError() != null) {
            resultMap.put("error_message", ExceptionUtils.printStackTrace(result.getError()));
        }
        if (!result.getDuration().isZero()) {
            resultMap.put("duration", result.getDuration().toNanos());
        }
        return resultMap;
    }

    private String getDateTimeFromTimeStamp(Instant instant) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").withZone(ZoneOffset.UTC);
        return formatter.format(instant);
    }
}

