/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.feature.GluePath;
import io.cucumber.core.options.ObjectFactoryParser;
import io.cucumber.core.options.OptionsFileParser;
import io.cucumber.core.options.PickleOrderParser;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import io.cucumber.core.options.SnippetTypeParser;
import io.cucumber.datatable.DataTable;
import io.cucumber.gherkin.GherkinDialect;
import io.cucumber.gherkin.GherkinDialectProvider;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class RuntimeOptionsParser {
    static final String VERSION = ResourceBundle.getBundle("io.cucumber.core.version").getString("cucumber-jvm.version");
    private static final String USAGE_RESOURCE = "/io/cucumber/core/options/USAGE.txt";
    static String usageText;

    RuntimeOptionsParser() {
    }

    private static void printUsage() {
        RuntimeOptionsParser.loadUsageTextIfNeeded();
        System.out.println(usageText);
    }

    static void loadUsageTextIfNeeded() {
        if (usageText == null) {
            InputStream usageResourceStream = RuntimeOptionsParser.class.getResourceAsStream(USAGE_RESOURCE);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(usageResourceStream, StandardCharsets.UTF_8));){
                usageText = br.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            catch (Exception e) {
                usageText = "Could not load usage text: " + e.toString();
            }
        }
    }

    private static int printI18n(String language) {
        GherkinDialectProvider dialectProvider = new GherkinDialectProvider();
        List<String> languages = dialectProvider.getLanguages();
        if (language.equalsIgnoreCase("help") && language.equalsIgnoreCase("help")) {
            ArrayList<GherkinDialect> dialects = new ArrayList<GherkinDialect>();
            for (String code : languages) {
                GherkinDialect dialect = dialectProvider.getDialect(code, null);
                dialects.add(dialect);
            }
            int widestLanguage = RuntimeOptionsParser.findWidest(dialects, GherkinDialect::getLanguage);
            int widestName = RuntimeOptionsParser.findWidest(dialects, GherkinDialect::getName);
            int widestNativeName = RuntimeOptionsParser.findWidest(dialects, GherkinDialect::getNativeName);
            for (GherkinDialect dialect : dialects) {
                RuntimeOptionsParser.printDialect(dialect, widestLanguage, widestName, widestNativeName);
            }
            return 0;
        }
        if (languages.contains(language)) {
            return RuntimeOptionsParser.printKeywordsFor(dialectProvider.getDialect(language, null));
        }
        System.err.println("Unrecognised ISO language code");
        return 1;
    }

    private static int findWidest(List<GherkinDialect> dialects, Function<GherkinDialect, String> getNativeName) {
        return dialects.stream().map(getNativeName).mapToInt(String::length).max().orElse(0);
    }

    private static int printKeywordsFor(GherkinDialect dialect) {
        StringBuilder builder = new StringBuilder();
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        RuntimeOptionsParser.addKeywordRow(table, "feature", dialect.getFeatureKeywords());
        RuntimeOptionsParser.addKeywordRow(table, "background", dialect.getBackgroundKeywords());
        RuntimeOptionsParser.addKeywordRow(table, "scenario", dialect.getScenarioKeywords());
        RuntimeOptionsParser.addKeywordRow(table, "scenario outline", dialect.getScenarioOutlineKeywords());
        RuntimeOptionsParser.addKeywordRow(table, "examples", dialect.getExamplesKeywords());
        RuntimeOptionsParser.addKeywordRow(table, "given", dialect.getGivenKeywords());
        RuntimeOptionsParser.addKeywordRow(table, "when", dialect.getWhenKeywords());
        RuntimeOptionsParser.addKeywordRow(table, "then", dialect.getThenKeywords());
        RuntimeOptionsParser.addKeywordRow(table, "and", dialect.getAndKeywords());
        RuntimeOptionsParser.addKeywordRow(table, "but", dialect.getButKeywords());
        RuntimeOptionsParser.addCodeKeywordRow(table, "given", dialect.getGivenKeywords());
        RuntimeOptionsParser.addCodeKeywordRow(table, "when", dialect.getWhenKeywords());
        RuntimeOptionsParser.addCodeKeywordRow(table, "then", dialect.getThenKeywords());
        RuntimeOptionsParser.addCodeKeywordRow(table, "and", dialect.getAndKeywords());
        RuntimeOptionsParser.addCodeKeywordRow(table, "but", dialect.getButKeywords());
        DataTable.create(table).print(builder);
        System.out.println(builder.toString());
        return 0;
    }

    private static void addCodeKeywordRow(List<List<String>> table, String key, List<String> keywords) {
        ArrayList<String> codeKeywordList = new ArrayList<String>(keywords);
        codeKeywordList.remove("* ");
        List<String> codeWords = codeKeywordList.stream().map(keyword -> keyword.replaceAll("[\\s',!]", "")).collect(Collectors.toList());
        RuntimeOptionsParser.addKeywordRow(table, key + " (code)", codeWords);
    }

    private static void addKeywordRow(List<List<String>> table, String key, List<String> keywords) {
        table.add(Arrays.asList(key, keywords.stream().map(o -> '\"' + o + '\"').collect(Collectors.joining(", "))));
    }

    private static void printDialect(GherkinDialect dialect, int widestLanguage, int widestName, int widestNativeName) {
        String langCode = RuntimeOptionsParser.rightPad(dialect.getLanguage(), widestLanguage);
        String name = RuntimeOptionsParser.rightPad(dialect.getName(), widestName);
        String nativeName = RuntimeOptionsParser.rightPad(dialect.getNativeName(), widestNativeName);
        System.out.println(langCode + name + nativeName);
    }

    private static String rightPad(String text, int maxWidth) {
        int padding = 7;
        int width = maxWidth + padding;
        return String.format("%" + -width + "s", text);
    }

    RuntimeOptionsBuilder parse(List<String> args) {
        args = new ArrayList<String>(args);
        RuntimeOptionsBuilder parsedOptions = new RuntimeOptionsBuilder();
        while (!args.isEmpty()) {
            String arg = args.remove(0).trim();
            if (arg.equals("--help") || arg.equals("-h")) {
                RuntimeOptionsParser.printUsage();
                System.exit(0);
                continue;
            }
            if (arg.equals("--version") || arg.equals("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (arg.equals("--i18n")) {
                String nextArg = this.removeArgFor(arg, args);
                System.exit(RuntimeOptionsParser.printI18n(nextArg));
                continue;
            }
            if (arg.equals("--threads")) {
                int threads = Integer.parseInt(this.removeArgFor(arg, args));
                if (threads < 1) {
                    throw new CucumberException("--threads must be > 0");
                }
                parsedOptions.setThreads(threads);
                continue;
            }
            if (arg.equals("--glue") || arg.equals("-g")) {
                String gluePath = this.removeArgFor(arg, args);
                URI parse = GluePath.parse(gluePath);
                parsedOptions.addGlue(parse);
                continue;
            }
            if (arg.equals("--tags") || arg.equals("-t")) {
                parsedOptions.addTagFilter(this.removeArgFor(arg, args));
                continue;
            }
            if (arg.equals("--plugin") || arg.equals("--add-plugin") || arg.equals("-p")) {
                parsedOptions.addPluginName(this.removeArgFor(arg, args), arg.equals("--add-plugin"));
                continue;
            }
            if (arg.equals("--no-dry-run") || arg.equals("--dry-run") || arg.equals("-d")) {
                parsedOptions.setDryRun(!arg.startsWith("--no-"));
                continue;
            }
            if (arg.equals("--no-strict") || arg.equals("--strict") || arg.equals("-s")) {
                parsedOptions.setStrict(!arg.startsWith("--no-"));
                continue;
            }
            if (arg.equals("--no-monochrome") || arg.equals("--monochrome") || arg.equals("-m")) {
                parsedOptions.setMonochrome(!arg.startsWith("--no-"));
                continue;
            }
            if (arg.equals("--snippets")) {
                String nextArg = this.removeArgFor(arg, args);
                parsedOptions.setSnippetType(SnippetTypeParser.parseSnippetType(nextArg));
                continue;
            }
            if (arg.equals("--name") || arg.equals("-n")) {
                String nextArg = this.removeArgFor(arg, args);
                Pattern pattern = Pattern.compile(nextArg);
                parsedOptions.addNameFilter(pattern);
                continue;
            }
            if (arg.equals("--wip") || arg.equals("-w")) {
                parsedOptions.setWip(true);
                continue;
            }
            if (arg.equals("--order")) {
                parsedOptions.setPickleOrder(PickleOrderParser.parse(this.removeArgFor(arg, args)));
                continue;
            }
            if (arg.equals("--count")) {
                int count = Integer.parseInt(this.removeArgFor(arg, args));
                if (count < 1) {
                    throw new CucumberException("--count must be > 0");
                }
                parsedOptions.setCount(count);
                continue;
            }
            if (arg.equals("--object-factory")) {
                String objectFactoryClassName = this.removeArgFor(arg, args);
                parsedOptions.setObjectFactoryClass(ObjectFactoryParser.parseObjectFactory(objectFactoryClassName));
                continue;
            }
            if (arg.startsWith("-")) {
                RuntimeOptionsParser.printUsage();
                throw new CucumberException("Unknown option: " + arg);
            }
            if (arg.isEmpty()) continue;
            if (arg.startsWith("@")) {
                Path rerunFile = Paths.get(arg.substring(1), new String[0]);
                parsedOptions.addRerun(OptionsFileParser.parseFeatureWithLinesFile(rerunFile));
                continue;
            }
            FeatureWithLines featureWithLines = FeatureWithLines.parse(arg);
            parsedOptions.addFeature(featureWithLines);
        }
        return parsedOptions;
    }

    private String removeArgFor(String arg, List<String> args) {
        if (!args.isEmpty()) {
            return args.remove(0);
        }
        RuntimeOptionsParser.printUsage();
        throw new CucumberException("Missing argument for " + arg);
    }
}

