/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.gherkin.Container;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Node;
import io.cucumber.core.plugin.TestSourceReadResource;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.HookType;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeamCityPlugin
implements EventListener {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'hh:mm:ss.SSSZ");
    private static final String TEAMCITY_PREFIX = "##teamcity";
    private static final String TEMPLATE_ENTER_THE_MATRIX = "##teamcity[enteredTheMatrix timestamp = '%s']";
    private static final String TEMPLATE_TEST_RUN_STARTED = "##teamcity[testSuiteStarted timestamp = '%s' name = 'Cucumber']";
    private static final String TEMPLATE_TEST_RUN_FINISHED = "##teamcity[testSuiteFinished timestamp = '%s' name = 'Cucumber']";
    private static final String TEMPLATE_TEST_SUITE_STARTED = "##teamcity[testSuiteStarted timestamp = '%s' locationHint = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_SUITE_FINISHED = "##teamcity[testSuiteFinished timestamp = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_STARTED = "##teamcity[testStarted timestamp = '%s' locationHint = '%s' captureStandardOutput = 'true' name = '%s']";
    private static final String TEMPLATE_TEST_FINISHED = "##teamcity[testFinished timestamp = '%s' duration = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_FAILED = "##teamcity[testFailed timestamp = '%s' duration = '%s' message = '%s' details = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_IGNORED = "##teamcity[testIgnored timestamp = '%s' duration = '%s' message = '%s' name = '%s']";
    private static final String TEMPLATE_PROGRESS_COUNTING_STARTED = "##teamcity[customProgressStatus testsCategory = 'Scenarios' count = '0' timestamp = '%s']";
    private static final String TEMPLATE_PROGRESS_COUNTING_FINISHED = "##teamcity[customProgressStatus testsCategory = '' count = '0' timestamp = '%s']";
    private static final String TEMPLATE_PROGRESS_TEST_STARTED = "##teamcity[customProgressStatus type = 'testStarted' timestamp = '%s']";
    private static final String TEMPLATE_PROGRESS_TEST_FINISHED = "##teamcity[customProgressStatus type = 'testFinished' timestamp = '%s']";
    private static final String TEMPLATE_EMBED_WRITE_EVENT = "##teamcity[message text='%s' status='NORMAL']";
    private static final Pattern ANNOTATION_GLUE_CODE_LOCATION_PATTERN = Pattern.compile("^(.*)\\.(.*)\\([^:]*\\)");
    private static final Pattern LAMBDA_GLUE_CODE_LOCATION_PATTERN = Pattern.compile("^(.*)\\.(.*)\\(.*:.*\\)");
    private final PrintStream out;
    private final List<SnippetsSuggestedEvent> snippets = new ArrayList<SnippetsSuggestedEvent>();
    private final Map<URI, Feature> features = new HashMap<URI, Feature>();
    private List<Node> currentStack = new ArrayList<Node>();
    private final FeatureParser featureParser = new FeatureParser(UUID::randomUUID);

    public TeamCityPlugin() {
        this(System.out);
    }

    TeamCityPlugin(PrintStream out) {
        this.out = out;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestRunStarted.class, this::printTestRunStarted);
        publisher.registerHandlerFor(TestCaseStarted.class, this::printTestCaseStarted);
        publisher.registerHandlerFor(TestStepStarted.class, this::printTestStepStarted);
        publisher.registerHandlerFor(TestStepFinished.class, this::printTestStepFinished);
        publisher.registerHandlerFor(TestCaseFinished.class, this::printTestCaseFinished);
        publisher.registerHandlerFor(TestRunFinished.class, this::printTestRunFinished);
        publisher.registerHandlerFor(SnippetsSuggestedEvent.class, this::handleSnippetSuggested);
        publisher.registerHandlerFor(EmbedEvent.class, this::handleEmbedEvent);
        publisher.registerHandlerFor(WriteEvent.class, this::handleWriteEvent);
        publisher.registerHandlerFor(TestSourceRead.class, this::handleTestSourceRead);
    }

    private void handleTestSourceRead(TestSourceRead event) {
        TestSourceReadResource source = new TestSourceReadResource(event);
        this.featureParser.parseResource(source).ifPresent(feature -> this.features.put(event.getUri(), (Feature)feature));
    }

    private void printTestRunStarted(TestRunStarted event) {
        String timestamp = this.extractTimeStamp((Event)event);
        this.print(TEMPLATE_ENTER_THE_MATRIX, timestamp);
        this.print(TEMPLATE_TEST_RUN_STARTED, timestamp);
        this.print(TEMPLATE_PROGRESS_COUNTING_STARTED, timestamp);
    }

    private String extractTimeStamp(Event event) {
        ZonedDateTime date = event.getInstant().atZone(ZoneOffset.UTC);
        return DATE_FORMAT.format(date);
    }

    private void printTestCaseStarted(TestCaseStarted event) {
        TestCase testCase = event.getTestCase();
        URI uri = testCase.getUri();
        Feature feature = this.features.get(uri);
        String timestamp = this.extractTimeStamp((Event)event);
        List<Node> newStack = this.extractStack(feature, testCase);
        this.poppedNodes(newStack).forEach(node -> this.finishNode(timestamp, (Node)node));
        this.pushedNodes(newStack).forEach(node -> this.startNode(uri, timestamp, (Node)node));
        this.currentStack = newStack;
        this.print(TEMPLATE_PROGRESS_TEST_STARTED, timestamp);
    }

    private void startNode(URI uri, String timestamp, Node node) {
        String name = node.getName() == null ? node.getKeyWord() : node.getName();
        String location = uri + ":" + node.getLocation().getLine();
        this.print(TEMPLATE_TEST_SUITE_STARTED, timestamp, location, name);
    }

    private void finishNode(String timestamp, Node node) {
        String name = node.getName() == null ? node.getKeyWord() : node.getName();
        this.print(TEMPLATE_TEST_SUITE_FINISHED, timestamp, name);
    }

    private List<Node> poppedNodes(List<Node> newStack) {
        ArrayList<Node> nodes = new ArrayList<Node>(this.reversedPoppedNodes(this.currentStack, newStack));
        Collections.reverse(nodes);
        return nodes;
    }

    private List<Node> reversedPoppedNodes(List<Node> currentStack, List<Node> newStack) {
        for (int i = 0; i < currentStack.size() && i < newStack.size(); ++i) {
            if (currentStack.get(i).equals(newStack.get(i))) continue;
            return currentStack.subList(i, currentStack.size());
        }
        if (newStack.size() < currentStack.size()) {
            return currentStack.subList(newStack.size(), currentStack.size());
        }
        return Collections.emptyList();
    }

    private List<Node> pushedNodes(List<Node> newStack) {
        for (int i = 0; i < this.currentStack.size() && i < newStack.size(); ++i) {
            if (this.currentStack.get(i).equals(newStack.get(i))) continue;
            return newStack.subList(i, newStack.size());
        }
        if (newStack.size() < this.currentStack.size()) {
            return Collections.emptyList();
        }
        return newStack.subList(this.currentStack.size(), newStack.size());
    }

    private List<Node> extractStack(Feature feature, TestCase testCase) {
        ArrayList<Node> stack = new ArrayList<Node>();
        this.findInFeature(stack, (Node)feature, testCase);
        Collections.reverse(stack);
        return stack;
    }

    private boolean findInFeature(List<Node> stack, Node node, TestCase testCase) {
        if (node.getLocation().getLine() == testCase.getLine().intValue()) {
            stack.add(node);
            return true;
        }
        if (node instanceof Container) {
            Container container = (Container)node;
            for (Node child : container.children()) {
                if (!this.findInFeature(stack, child, testCase)) continue;
                stack.add(node);
                return true;
            }
        }
        return false;
    }

    private void printTestStepStarted(TestStepStarted event) {
        String timestamp = this.extractTimeStamp((Event)event);
        String name = this.extractName(event.getTestStep());
        String location = this.extractLocation(event);
        this.print(TEMPLATE_TEST_STARTED, timestamp, location, name);
    }

    private String extractLocation(TestStepStarted event) {
        TestStep testStep = event.getTestStep();
        if (testStep instanceof PickleStepTestStep) {
            PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
            return pickleStepTestStep.getUri() + ":" + pickleStepTestStep.getStep().getLine();
        }
        return this.extractSourceLocation(testStep);
    }

    private String extractSourceLocation(TestStep testStep) {
        Matcher javaMatcher = ANNOTATION_GLUE_CODE_LOCATION_PATTERN.matcher(testStep.getCodeLocation());
        if (javaMatcher.matches()) {
            String fqDeclaringClassName = javaMatcher.group(1);
            String methodName = javaMatcher.group(2);
            return String.format("java:test://%s/%s", fqDeclaringClassName, methodName);
        }
        Matcher java8Matcher = LAMBDA_GLUE_CODE_LOCATION_PATTERN.matcher(testStep.getCodeLocation());
        if (java8Matcher.matches()) {
            String fqDeclaringClassName = java8Matcher.group(1);
            int indexOfPackageSeparator = fqDeclaringClassName.indexOf(".");
            String declaringClassName = indexOfPackageSeparator != -1 ? fqDeclaringClassName.substring(indexOfPackageSeparator + 1) : fqDeclaringClassName;
            return String.format("java:test://%s/%s", fqDeclaringClassName, declaringClassName);
        }
        return testStep.getCodeLocation();
    }

    private void printTestStepFinished(TestStepFinished event) {
        String timeStamp = this.extractTimeStamp((Event)event);
        long duration = this.extractDuration(event.getResult());
        String name = this.extractName(event.getTestStep());
        Throwable error = event.getResult().getError();
        Status status = event.getResult().getStatus();
        switch (status) {
            case SKIPPED: {
                this.print(TEMPLATE_TEST_IGNORED, timeStamp, duration, error == null ? "Step skipped" : error.getMessage(), name);
                break;
            }
            case PENDING: {
                this.print(TEMPLATE_TEST_IGNORED, timeStamp, duration, error == null ? "Step pending" : error.getMessage(), name);
                break;
            }
            case UNDEFINED: {
                PickleStepTestStep testStep = (PickleStepTestStep)event.getTestStep();
                this.print(TEMPLATE_TEST_FAILED, timeStamp, duration, "Step undefined", this.getSnippet(testStep), name);
                break;
            }
            case AMBIGUOUS: 
            case FAILED: {
                String details = this.extractStackTrace(error);
                this.print(TEMPLATE_TEST_FAILED, timeStamp, duration, "Step failed", details, name);
                break;
            }
        }
        this.print(TEMPLATE_TEST_FINISHED, timeStamp, duration, name);
    }

    private String extractStackTrace(Throwable error) {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(s);
        error.printStackTrace(printStream);
        return new String(s.toByteArray(), StandardCharsets.UTF_8);
    }

    private String extractName(TestStep step) {
        if (step instanceof PickleStepTestStep) {
            PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)step;
            return pickleStepTestStep.getStep().getText();
        }
        if (step instanceof HookTestStep) {
            HookTestStep hook = (HookTestStep)step;
            HookType hookType = hook.getHookType();
            switch (hookType) {
                case BEFORE: {
                    return "Before";
                }
                case AFTER: {
                    return "After";
                }
                case BEFORE_STEP: {
                    return "BeforeStep";
                }
                case AFTER_STEP: {
                    return "AfterStep";
                }
            }
            return hookType.name().toLowerCase(Locale.US);
        }
        return "Unknown step";
    }

    private String getSnippet(PickleStepTestStep testStep) {
        StringBuilder builder = new StringBuilder();
        if (this.snippets.isEmpty()) {
            return builder.toString();
        }
        this.snippets.stream().filter(snippet -> snippet.getStepLine() == testStep.getStep().getLine() && snippet.getUri().equals(testStep.getUri())).findFirst().ifPresent(event -> {
            builder.append("You can implement missing steps with the snippets below:\n");
            event.getSnippets().forEach(snippet -> {
                builder.append((String)snippet);
                builder.append("\n");
            });
        });
        return builder.toString();
    }

    private void printTestCaseFinished(TestCaseFinished event) {
        String timestamp = this.extractTimeStamp((Event)event);
        this.print(TEMPLATE_PROGRESS_TEST_FINISHED, timestamp);
        this.finishNode(timestamp, this.currentStack.remove(this.currentStack.size() - 1));
    }

    private long extractDuration(Result result) {
        return result.getDuration().toMillis();
    }

    private void printTestRunFinished(TestRunFinished event) {
        String timestamp = this.extractTimeStamp((Event)event);
        this.print(TEMPLATE_PROGRESS_COUNTING_FINISHED, timestamp);
        ArrayList<Node> emptyStack = new ArrayList<Node>();
        this.poppedNodes(emptyStack).forEach(node -> this.finishNode(timestamp, (Node)node));
        this.currentStack = emptyStack;
        this.print(TEMPLATE_TEST_RUN_FINISHED, timestamp);
    }

    private void handleSnippetSuggested(SnippetsSuggestedEvent event) {
        this.snippets.add(event);
    }

    private void handleEmbedEvent(EmbedEvent event) {
        String name = event.getName() == null ? "" : event.getName() + " ";
        this.print(TEMPLATE_EMBED_WRITE_EVENT, "Embed event: " + name + "[" + event.getMediaType() + " " + event.getData().length + " bytes]\n");
    }

    private void handleWriteEvent(WriteEvent event) {
        this.print(TEMPLATE_EMBED_WRITE_EVENT, "Write event:\n" + event.getText() + "\n");
    }

    private void print(String command, Object ... args) {
        this.out.println(this.formatCommand(command, args));
    }

    private String formatCommand(String command, Object ... parameters) {
        Object[] escapedParameters = new String[parameters.length];
        for (int i = 0; i < escapedParameters.length; ++i) {
            escapedParameters[i] = this.escape(parameters[i].toString());
        }
        return String.format(command, escapedParameters);
    }

    private String escape(String source) {
        if (source == null) {
            return "";
        }
        return source.replace("|", "||").replace("'", "|'").replace("\n", "|n").replace("\r", "|r").replace("[", "|[").replace("]", "|]");
    }
}

