/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.internal.gherkin.deps.com.google.gson.Gson;
import io.cucumber.core.internal.gherkin.deps.com.google.gson.GsonBuilder;
import io.cucumber.core.internal.gherkin.deps.com.google.gson.JsonPrimitive;
import io.cucumber.core.internal.gherkin.deps.com.google.gson.JsonSerializer;
import io.cucumber.core.plugin.NiceAppendable;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestStepFinished;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class UsageFormatter
implements Plugin,
EventListener {
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    final Map<String, List<StepContainer>> usageMap = new LinkedHashMap<String, List<StepContainer>>();
    private final NiceAppendable out;

    public UsageFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestStepFinished.class, this::handleTestStepFinished);
        publisher.registerHandlerFor(TestRunFinished.class, event -> this.finishReport());
    }

    void handleTestStepFinished(TestStepFinished event) {
        if (event.getTestStep() instanceof PickleStepTestStep && event.getResult().getStatus().is(Status.PASSED)) {
            PickleStepTestStep testStep = (PickleStepTestStep)event.getTestStep();
            this.addUsageEntry(event.getResult(), testStep);
        }
    }

    void finishReport() {
        ArrayList<StepDefContainer> stepDefContainers = new ArrayList<StepDefContainer>();
        for (Map.Entry<String, List<StepContainer>> usageEntry : this.usageMap.entrySet()) {
            StepDefContainer stepDefContainer = new StepDefContainer(usageEntry.getKey(), this.createStepContainers(usageEntry.getValue()));
            stepDefContainers.add(stepDefContainer);
        }
        this.gson().toJson(stepDefContainers, (Appendable)this.out);
        this.out.close();
    }

    private List<StepContainer> createStepContainers(List<StepContainer> stepContainers) {
        for (StepContainer stepContainer : stepContainers) {
            stepContainer.putAllAggregatedDurations(this.createAggregatedDurations(stepContainer));
        }
        return stepContainers;
    }

    private Map<String, Duration> createAggregatedDurations(StepContainer stepContainer) {
        LinkedHashMap<String, Duration> aggregatedResults = new LinkedHashMap<String, Duration>();
        List<Duration> rawDurations = this.getRawDurations(stepContainer.getDurations());
        Duration average = this.calculateAverage(rawDurations);
        aggregatedResults.put("average", average);
        Duration median = this.calculateMedian(rawDurations);
        aggregatedResults.put("median", median);
        return aggregatedResults;
    }

    private List<Duration> getRawDurations(List<StepDuration> stepDurations) {
        ArrayList<Duration> rawDurations = new ArrayList<Duration>();
        for (StepDuration stepDuration : stepDurations) {
            rawDurations.add(stepDuration.duration);
        }
        return rawDurations;
    }

    private Gson gson() {
        JsonSerializer<Duration> durationJsonSerializer = (duration, returnVal, jsonSerializationContext) -> new JsonPrimitive((double)duration.getNano() / (double)NANOS_PER_SECOND);
        return new GsonBuilder().registerTypeAdapter((Type)((Object)Duration.class), durationJsonSerializer).setPrettyPrinting().create();
    }

    private void addUsageEntry(Result result, PickleStepTestStep testStep) {
        List stepContainers = this.usageMap.computeIfAbsent(testStep.getPattern(), k -> new ArrayList());
        StepContainer stepContainer = this.findOrCreateStepContainer(testStep.getStepText(), stepContainers);
        StepDuration stepDuration = new StepDuration(result.getDuration(), testStep.getUri() + ":" + testStep.getStepLine());
        stepContainer.getDurations().add(stepDuration);
    }

    private StepContainer findOrCreateStepContainer(String stepNameWithArgs, List<StepContainer> stepContainers) {
        for (StepContainer container : stepContainers) {
            if (!stepNameWithArgs.equals(container.getName())) continue;
            return container;
        }
        StepContainer stepContainer = new StepContainer(stepNameWithArgs);
        stepContainers.add(stepContainer);
        return stepContainer;
    }

    Duration calculateAverage(List<Duration> durationEntries) {
        Duration sum = Duration.ZERO;
        for (Duration duration : durationEntries) {
            sum = sum.plus(duration);
        }
        if (sum.isZero()) {
            return Duration.ZERO;
        }
        return sum.dividedBy(durationEntries.size());
    }

    Duration calculateMedian(List<Duration> durationEntries) {
        if (durationEntries.isEmpty()) {
            return Duration.ZERO;
        }
        Collections.sort(durationEntries);
        int middle = durationEntries.size() / 2;
        if (durationEntries.size() % 2 == 1) {
            return durationEntries.get(middle);
        }
        Duration total = durationEntries.get(middle - 1).plus(durationEntries.get(middle));
        return total.dividedBy(2L);
    }

    static class StepDuration {
        private final Duration duration;
        private final String location;

        StepDuration(Duration duration, String location) {
            this.duration = duration;
            this.location = location;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public String getLocation() {
            return this.location;
        }
    }

    static class StepContainer {
        private final String name;
        private final Map<String, Duration> aggregatedDurations = new HashMap<String, Duration>();
        private final List<StepDuration> durations = new ArrayList<StepDuration>();

        StepContainer(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        void putAllAggregatedDurations(Map<String, Duration> aggregatedDurations) {
            this.aggregatedDurations.putAll(aggregatedDurations);
        }

        public Map<String, Duration> getAggregatedDurations() {
            return this.aggregatedDurations;
        }

        List<StepDuration> getDurations() {
            return this.durations;
        }
    }

    static class StepDefContainer {
        private final String source;
        private final List<StepContainer> steps;

        StepDefContainer(String source, List<StepContainer> steps) {
            this.source = source;
            this.steps = steps;
        }

        public String getSource() {
            return this.source;
        }

        public List<StepContainer> getSteps() {
            return this.steps;
        }
    }
}

