/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import cucumber.api.SnippetType;
import cucumber.runtime.order.PickleOrder;
import cucumber.runtime.order.StandardPickleOrders;
import io.cucumber.core.options.FeatureOptions;
import io.cucumber.core.options.FilterOptions;
import io.cucumber.core.options.PluginOptions;
import io.cucumber.core.options.RunnerOptions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public final class RuntimeOptions
implements FeatureOptions,
FilterOptions,
PluginOptions,
RunnerOptions {
    private final List<URI> glue = new ArrayList<URI>();
    private final List<String> tagFilters = new ArrayList<String>();
    private final List<Pattern> nameFilters = new ArrayList<Pattern>();
    private final Map<URI, Set<Integer>> lineFilters = new HashMap<URI, Set<Integer>>();
    private final SortedSet<URI> featurePaths = new TreeSet<URI>();
    private final List<String> junitOptions = new ArrayList<String>();
    private boolean dryRun;
    private boolean strict = false;
    private boolean monochrome = false;
    private boolean wip = false;
    private SnippetType snippetType = SnippetType.UNDERSCORE;
    private int threads = 1;
    private PickleOrder pickleOrder = StandardPickleOrders.lexicalUriOrder();
    private int count = 0;
    private final List<String> pluginFormatterNames = new ArrayList<String>();
    private final List<String> pluginStepDefinitionReporterNames = new ArrayList<String>();
    private final List<String> pluginSummaryPrinterNames = new ArrayList<String>();

    private RuntimeOptions() {
    }

    public static RuntimeOptions defaultOptions() {
        return new RuntimeOptions();
    }

    public void addUndefinedStepsPrinterIfSummaryNotDefined() {
        if (this.pluginSummaryPrinterNames.isEmpty()) {
            this.pluginSummaryPrinterNames.add("undefined");
        }
    }

    public int getCount() {
        return this.count;
    }

    List<String> getPluginFormatterNames() {
        return this.pluginFormatterNames;
    }

    List<String> getPluginStepDefinitionReporterNames() {
        return this.pluginStepDefinitionReporterNames;
    }

    List<String> getPluginSummaryPrinterNames() {
        return this.pluginSummaryPrinterNames;
    }

    public boolean isMultiThreaded() {
        return this.getThreads() > 1;
    }

    @Override
    public List<String> getPluginNames() {
        ArrayList<String> pluginNames = new ArrayList<String>();
        pluginNames.addAll(this.getPluginFormatterNames());
        pluginNames.addAll(this.getPluginStepDefinitionReporterNames());
        pluginNames.addAll(this.getPluginSummaryPrinterNames());
        return pluginNames;
    }

    @Override
    public List<URI> getGlue() {
        return Collections.unmodifiableList(this.glue);
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isWip() {
        return this.wip;
    }

    @Override
    public List<URI> getFeaturePaths() {
        return Collections.unmodifiableList(new ArrayList<URI>(this.featurePaths));
    }

    @Override
    public List<Pattern> getNameFilters() {
        return Collections.unmodifiableList(this.nameFilters);
    }

    @Override
    public List<String> getTagFilters() {
        return Collections.unmodifiableList(this.tagFilters);
    }

    void setCount(int count) {
        this.count = count;
    }

    void setFeaturePaths(List<URI> featurePaths) {
        this.featurePaths.clear();
        this.featurePaths.addAll(featurePaths);
    }

    void setGlue(List<URI> parsedGlue) {
        this.glue.clear();
        this.glue.addAll(parsedGlue);
    }

    void setJunitOptions(List<String> junitOptions) {
        this.junitOptions.clear();
        this.junitOptions.addAll(junitOptions);
    }

    void setLineFilters(Map<URI, Set<Integer>> lineFilters) {
        this.lineFilters.clear();
        for (URI path : lineFilters.keySet()) {
            this.lineFilters.put(path, lineFilters.get(path));
        }
    }

    void setNameFilters(List<Pattern> nameFilters) {
        this.nameFilters.clear();
        this.nameFilters.addAll(nameFilters);
    }

    void setPickleOrder(PickleOrder pickleOrder) {
        this.pickleOrder = pickleOrder;
    }

    void setTagFilters(List<String> tagFilters) {
        this.tagFilters.clear();
        this.tagFilters.addAll(tagFilters);
    }

    @Override
    public Map<URI, Set<Integer>> getLineFilters() {
        return Collections.unmodifiableMap(new HashMap<URI, Set<Integer>>(this.lineFilters));
    }

    @Override
    public int getLimitCount() {
        return this.getCount();
    }

    @Override
    public boolean isMonochrome() {
        return this.monochrome;
    }

    @Override
    public SnippetType getSnippetType() {
        return this.snippetType;
    }

    public List<String> getJunitOptions() {
        return Collections.unmodifiableList(this.junitOptions);
    }

    public int getThreads() {
        return this.threads;
    }

    public PickleOrder getPickleOrder() {
        return this.pickleOrder;
    }

    void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    void setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
    }

    void setSnippetType(SnippetType snippetType) {
        this.snippetType = snippetType;
    }

    void setStrict(boolean strict) {
        this.strict = strict;
    }

    void setThreads(int threads) {
        this.threads = threads;
    }

    void setWip(boolean wip) {
        this.wip = wip;
    }
}

