/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.snippets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ArgumentPattern {
    private final Pattern pattern;
    private final String replacement;

    ArgumentPattern(Pattern pattern) {
        this(pattern, pattern.pattern());
    }

    private ArgumentPattern(Pattern pattern, String replacement) {
        this.pattern = pattern;
        this.replacement = replacement;
    }

    String replaceMatchesWithGroups(String name) {
        return this.replaceMatchWith(name, this.replacement);
    }

    String replaceMatchesWithSpace(String name) {
        return this.replaceMatchWith(name, " ");
    }

    private String replaceMatchWith(String name, String replacement) {
        Matcher matcher = this.pattern.matcher(name);
        String quotedReplacement = Matcher.quoteReplacement(replacement);
        return matcher.replaceAll(quotedReplacement);
    }
}

