/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.filter;

import cucumber.runtime.filter.LinePredicate;
import cucumber.runtime.filter.NamePredicate;
import cucumber.runtime.filter.PicklePredicate;
import cucumber.runtime.filter.TagPredicate;
import gherkin.events.PickleEvent;
import io.cucumber.core.options.FilterOptions;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class Filters {
    private final List<PicklePredicate> filters = new ArrayList<PicklePredicate>();
    private int count;

    public Filters(FilterOptions filterOptions) {
        Map<URI, Set<Integer>> lineFilters;
        List<Pattern> nameFilters;
        List<String> tagFilters = filterOptions.getTagFilters();
        if (!tagFilters.isEmpty()) {
            this.filters.add(new TagPredicate(tagFilters));
        }
        if (!(nameFilters = filterOptions.getNameFilters()).isEmpty()) {
            this.filters.add(new NamePredicate(nameFilters));
        }
        if (!(lineFilters = filterOptions.getLineFilters()).isEmpty()) {
            this.filters.add(new LinePredicate(lineFilters));
        }
        this.count = filterOptions.getLimitCount();
    }

    public boolean matchesFilters(PickleEvent pickleEvent) {
        for (PicklePredicate filter : this.filters) {
            if (filter.apply(pickleEvent)) continue;
            return false;
        }
        return true;
    }

    public List<PickleEvent> limitPickleEvents(List<PickleEvent> pickleEvents) {
        if (this.count > pickleEvents.size() || this.count < 1) {
            return pickleEvents;
        }
        return pickleEvents.subList(0, this.count);
    }
}

