/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cdi2;

import io.cucumber.core.backend.ObjectFactory;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Unmanaged;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class Cdi2Factory
implements ObjectFactory,
Extension {
    private final Set<Class<?>> stepClasses = new HashSet();
    private final Map<Class<?>, Unmanaged.UnmanagedInstance<?>> standaloneInstances = new HashMap();
    private SeContainer container;

    public void start() {
        if (this.container == null) {
            SeContainerInitializer initializer = SeContainerInitializer.newInstance();
            initializer.addExtensions(new Extension[]{this});
            this.container = initializer.initialize();
        }
    }

    public void stop() {
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
        for (Unmanaged.UnmanagedInstance<?> unmanaged : this.standaloneInstances.values()) {
            unmanaged.preDestroy();
            unmanaged.dispose();
        }
        this.standaloneInstances.clear();
    }

    public boolean addClass(Class<?> clazz) {
        this.stepClasses.add(clazz);
        return true;
    }

    public <T> T getInstance(Class<T> type) {
        Unmanaged.UnmanagedInstance<?> instance = this.standaloneInstances.get(type);
        if (instance != null) {
            return type.cast(instance.get());
        }
        Instance selected = this.container.select(type, new Annotation[0]);
        if (selected.isUnsatisfied()) {
            BeanManager beanManager = this.container.getBeanManager();
            Unmanaged unmanaged = new Unmanaged(beanManager, type);
            Unmanaged.UnmanagedInstance value = unmanaged.newInstance();
            value.produce();
            value.inject();
            value.postConstruct();
            this.standaloneInstances.put(type, value);
            return (T)value.get();
        }
        return (T)selected.get();
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager bm) {
        HashSet unmanaged = new HashSet();
        for (Class<?> stepClass : this.stepClasses) {
            this.discoverUnmanagedTypes(afterBeanDiscovery, bm, unmanaged, stepClass);
        }
    }

    private void discoverUnmanagedTypes(AfterBeanDiscovery afterBeanDiscovery, BeanManager bm, Set<Class<?>> unmanaged, Class<?> candidate) {
        if (unmanaged.contains(candidate) || !bm.getBeans(candidate, new Annotation[0]).isEmpty()) {
            return;
        }
        unmanaged.add(candidate);
        this.addBean(afterBeanDiscovery, bm, candidate);
    }

    private void addBean(AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager, Class<?> clazz) {
        AnnotatedType clazzAnnotatedType = beanManager.createAnnotatedType(clazz);
        InjectionTarget injectionTarget = beanManager.getInjectionTargetFactory(clazzAnnotatedType).createInjectionTarget(null);
        afterBeanDiscovery.addBean().read(clazzAnnotatedType).createWith(callback -> {
            CreationalContext c = (CreationalContext)callback;
            Object instance = injectionTarget.produce(c);
            injectionTarget.inject(instance, c);
            injectionTarget.postConstruct(instance);
            return instance;
        });
    }
}

