/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cdi2;

import io.cucumber.core.backend.ObjectFactory;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import javax.enterprise.inject.spi.Unmanaged;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class Cdi2Factory
implements ObjectFactory {
    private SeContainerInitializer initializer;
    private SeContainer container;
    private final Map<Class<?>, Unmanaged.UnmanagedInstance<?>> standaloneInstances = new HashMap();

    public void start() {
        this.container = this.getInitializer().initialize();
    }

    public void stop() {
        if (this.container != null) {
            this.container.close();
            this.container = null;
            this.initializer = null;
        }
        for (Unmanaged.UnmanagedInstance<?> unmanaged : this.standaloneInstances.values()) {
            unmanaged.preDestroy();
            unmanaged.dispose();
        }
        this.standaloneInstances.clear();
    }

    public boolean addClass(Class<?> clazz) {
        this.getInitializer().addBeanClasses(new Class[]{clazz});
        return true;
    }

    public <T> T getInstance(Class<T> type) {
        Unmanaged.UnmanagedInstance<?> instance = this.standaloneInstances.get(type);
        if (instance != null) {
            return type.cast(instance);
        }
        Instance selected = this.container.select(type, new Annotation[0]);
        if (selected.isUnsatisfied()) {
            Unmanaged.UnmanagedInstance value = new Unmanaged(this.container.getBeanManager(), type).newInstance();
            value.produce();
            value.inject();
            value.postConstruct();
            this.standaloneInstances.put(type, value);
            return (T)value.get();
        }
        return (T)selected.get();
    }

    private SeContainerInitializer getInitializer() {
        if (this.initializer == null) {
            this.initializer = SeContainerInitializer.newInstance();
        }
        return this.initializer;
    }
}

