/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.cucumber.junit.CucumberJUnitRunnerBuilder;

public class CucumberAndroidJUnitArguments {
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    @NonNull
    private final Bundle originalArgs;
    @Nullable
    private Bundle processedArgs;

    public CucumberAndroidJUnitArguments(@NonNull Bundle arguments) {
        this.originalArgs = new Bundle(arguments);
    }

    public Bundle processArgs() {
        this.processedArgs = new Bundle(this.originalArgs);
        if (TRUE.equals(this.originalArgs.getString("cucumberUseAndroidJUnitRunner", FALSE))) {
            return this.processedArgs;
        }
        this.processedArgs.putString("runnerBuilder", CucumberJUnitRunnerBuilder.class.getName());
        String testClass = this.originalArgs.getString("class");
        if (testClass != null && !testClass.isEmpty()) {
            this.processedArgs.putString("cucumberAndroidTestClass", testClass);
        }
        this.processedArgs.putString("class", CucumberJUnitRunnerBuilder.class.getName());
        return this.processedArgs;
    }

    @NonNull
    Bundle getRunnerArgs() {
        if (this.processedArgs == null) {
            this.processedArgs = this.processArgs();
        }
        return this.processedArgs;
    }

    private static class AndroidJunitRunnerArgs {
        private static final String ARGUMENT_ORCHESTRATOR_RUNNER_BUILDER = "runnerBuilder";
        private static final String ARGUMENT_ORCHESTRATOR_CLASS = "class";

        private AndroidJunitRunnerArgs() {
        }
    }

    static class InternalCucumberAndroidArgs {
        static final String CUCUMBER_ANDROID_TEST_CLASS = "cucumberAndroidTestClass";

        InternalCucumberAndroidArgs() {
        }
    }

    public static class Args {
        public static final String USE_DEFAULT_ANDROID_RUNNER = "cucumberUseAndroidJUnitRunner";
    }
}

