/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import cucumber.runner.Runner;
import cucumber.runtime.model.CucumberFeature;
import gherkin.events.PickleEvent;
import gherkin.pickles.PickleStep;
import io.cucumber.junit.JUnitOptions;
import io.cucumber.junit.JUnitReporter;
import io.cucumber.junit.PickleRunners;
import java.io.Serializable;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;

public class AndroidPickleRunner
implements PickleRunners.PickleRunner {
    private final Runner runner;
    private final PickleEvent pickleEvent;
    private final JUnitOptions jUnitOptions;
    private Description description;
    private final CucumberFeature feature;
    private String scenarioName;

    public AndroidPickleRunner(Runner runner, PickleEvent pickleEvent, JUnitOptions jUnitOptions, CucumberFeature feature, String scenarioName) {
        this.runner = runner;
        this.pickleEvent = pickleEvent;
        this.jUnitOptions = jUnitOptions;
        this.feature = feature;
        this.scenarioName = scenarioName;
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = this.makeDescriptionFromPickle();
        }
        return this.description;
    }

    public Description describeChild(PickleStep step) {
        throw new UnsupportedOperationException("This pickle runner does not wish to describe its children");
    }

    public void run(RunNotifier notifier) {
        JUnitReporter jUnitReporter = new JUnitReporter(this.runner.getBus(), this.jUnitOptions);
        jUnitReporter.startExecutionUnit((PickleRunners.PickleRunner)this, notifier);
        this.runner.runPickle(this.pickleEvent);
        jUnitReporter.finishExecutionUnit();
    }

    private Description makeDescriptionFromPickle() {
        return Description.createTestDescription((String)this.feature.getName(), (String)this.scenarioName, (Serializable)new PickleRunners.PickleId(this.pickleEvent));
    }
}

