/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cienvironment;

import io.cucumber.cienvironment.CiEnvironment;
import io.cucumber.cienvironment.CiEnvironments;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public final class DetectCiEnvironment {
    private DetectCiEnvironment() {
    }

    public static Optional<CiEnvironment> detectCiEnvironment(Map<String, String> env) {
        return DetectCiEnvironment.detectCiEnvironment(env, path -> {
            try {
                return Files.lines(path);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't read " + path, e);
            }
        });
    }

    static Optional<CiEnvironment> detectCiEnvironment(Map<String, String> env, Function<Path, Stream<String>> getLines) {
        return CiEnvironments.TEMPLATES.stream().map(ciEnvironment -> ciEnvironment.detect(env, getLines)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }
}

