/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cienvironment;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

final class VariableExpression {
    private static final Pattern variablePattern = Pattern.compile("\\$\\{(.*?)(?:(?<!\\\\)/(.*)/(.*))?}");

    private VariableExpression() {
    }

    static @Nullable String evaluate(@Nullable String expression, Map<String, String> env) {
        if (expression == null) {
            return null;
        }
        Matcher variableMatcher = variablePattern.matcher(expression);
        StringBuilder sb = new StringBuilder();
        while (variableMatcher.find()) {
            String variable = variableMatcher.group(1);
            String value = VariableExpression.getValue(env, variable);
            if (value == null) {
                return null;
            }
            String pattern = variableMatcher.group(2);
            if (pattern == null) {
                variableMatcher.appendReplacement(sb, Matcher.quoteReplacement(value));
                continue;
            }
            Matcher matcher = Pattern.compile(pattern.replace("\\/", "/")).matcher(value);
            if (!matcher.matches()) {
                return null;
            }
            String replacement = variableMatcher.group(3);
            for (int i = 0; i < matcher.groupCount(); ++i) {
                String group = matcher.group(i + 1);
                replacement = replacement.replace("\\" + (i + 1), group);
            }
            variableMatcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        variableMatcher.appendTail(sb);
        return sb.toString();
    }

    private static @Nullable String getValue(Map<String, String> env, String variable) {
        if (variable.contains("*")) {
            Pattern pattern = Pattern.compile(variable.replace("*", ".*"));
            for (Map.Entry<String, String> nameAndValue : env.entrySet()) {
                if (!pattern.matcher(nameAndValue.getKey()).matches()) continue;
                return nameAndValue.getValue();
            }
        }
        return env.get(variable);
    }
}

