/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cienvironment;

import io.cucumber.cienvironment.CiEnvironment;
import io.cucumber.cienvironment.CiEnvironmentImpl;
import io.cucumber.cienvironment.CiEnvironments;
import io.cucumber.cienvironment.GithubEventParser;
import io.cucumber.cienvironment.RemoveUserInfo;
import io.cucumber.cienvironment.VariableExpression;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class DetectCiEnvironment {
    private DetectCiEnvironment() {
    }

    public static Optional<CiEnvironment> detectCiEnvironment(Map<String, String> env) {
        return CiEnvironments.TEMPLATES.stream().map(ciEnvironment -> DetectCiEnvironment.detect(ciEnvironment, env)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private static Optional<CiEnvironment> detect(CiEnvironment ci, Map<String, String> env) {
        String url = VariableExpression.evaluate(ci.getUrl(), env);
        if (url == null) {
            return Optional.empty();
        }
        return Optional.of(new CiEnvironmentImpl(ci.getName(), url, ci.getBuildNumber().map(buildNumber -> VariableExpression.evaluate(buildNumber, env)).orElse(null), DetectCiEnvironment.detectGit(ci, env)));
    }

    private static @Nullable CiEnvironmentImpl.Git detectGit(CiEnvironment ci, Map<String, String> env) {
        String revision = DetectCiEnvironment.evaluateRevision(ci, env);
        if (revision == null) {
            return null;
        }
        if (!ci.getGit().isPresent()) {
            return null;
        }
        CiEnvironment.Git git = ci.getGit().get();
        String remote = VariableExpression.evaluate(git.getRemote(), env);
        if (remote == null) {
            return null;
        }
        return new CiEnvironmentImpl.Git(RemoveUserInfo.fromUrl(remote), revision, git.getBranch().map(branch -> VariableExpression.evaluate(branch, env)).orElse(null), git.getTag().map(tag -> VariableExpression.evaluate(tag, env)).orElse(null));
    }

    private static @Nullable String evaluateRevision(CiEnvironment ci, Map<String, String> env) {
        String revision = GithubEventParser.evaluateRevisionGithub(env);
        if (revision != null) {
            return revision;
        }
        return ci.getGit().map(git -> VariableExpression.evaluate(git.getRevision(), env)).orElse(null);
    }
}

