/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public interface Prioritizable {
    public int getPriority();

    public static <T> List<T> prioritze(List<T> list) {
        final HashMap<T, Integer> indexMap = new HashMap<T, Integer>();
        int index = 0;
        for (T item : list) {
            indexMap.put(item, index--);
        }
        ArrayList<T> results = new ArrayList<T>(list);
        Collections.sort(results, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int p2;
                int p1 = this.getPriority(o1);
                if (p1 == (p2 = this.getPriority(o2))) {
                    p1 = (Integer)indexMap.get(o1);
                    p2 = (Integer)indexMap.get(o2);
                }
                return p1 - p2;
            }

            private int getPriority(T o1) {
                if (o1 instanceof Prioritizable) {
                    return ((Prioritizable)o1).getPriority();
                }
                return 0;
            }
        });
        return results;
    }
}

