/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.repository.foward.strategy;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.foward.strategy.ForwardingGetStrategy;
import io.crnk.core.repository.foward.strategy.ForwardingStrategyBase;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.links.PagedLinksInformation;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class GetFromOppositeStrategy<T, I extends Serializable, D, J extends Serializable>
extends ForwardingStrategyBase
implements ForwardingGetStrategy<T, I, D, J> {
    @Override
    public MultivaluedMap<I, D> findTargets(Iterable<I> sourceIds, String fieldName, QuerySpec querySpec, QueryContext queryContext) {
        RegistryEntry sourceEntry = this.context.getSourceEntry();
        ResourceInformation sourceInformation = sourceEntry.getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        RegistryEntry targetEntry = this.context.getTargetEntry(field);
        ResourceInformation targetInformation = targetEntry.getResourceInformation();
        ResourceField oppositeField = Objects.requireNonNull(targetInformation.findFieldByUnderlyingName(field.getOppositeName()));
        QuerySpec idQuerySpec = querySpec.clone();
        idQuerySpec.addFilter(new FilterSpec(Arrays.asList(oppositeField.getUnderlyingName(), sourceInformation.getIdField().getUnderlyingName()), FilterOperator.EQ, sourceIds));
        idQuerySpec.includeRelation(Arrays.asList(oppositeField.getUnderlyingName()));
        ResourceRepositoryAdapter targetAdapter = targetEntry.getResourceRepository();
        JsonApiResponse response = targetAdapter.findAll(this.context.createQueryAdapter(idQuerySpec, queryContext)).get();
        Collection results = (Collection)response.getEntity();
        Iterator<I> iterator = sourceIds.iterator();
        if (iterator.hasNext()) {
            Serializable sourceId = (Serializable)iterator.next();
            if (!iterator.hasNext()) {
                MultivaluedMap bulkResult = new MultivaluedMap();
                if (results instanceof ResourceList) {
                    bulkResult.set(sourceId, (List)results);
                    ResourceList resourceList = (ResourceList)results;
                    LinksInformation links = resourceList.getLinks();
                    if (links instanceof PagedLinksInformation) {
                        PagedLinksInformation pagedLinksInformation = (PagedLinksInformation)links;
                        pagedLinksInformation.setFirst(null);
                        pagedLinksInformation.setLast(null);
                        pagedLinksInformation.setNext(null);
                        pagedLinksInformation.setPrev(null);
                    }
                    return bulkResult;
                }
            }
        }
        MultivaluedMap bulkResult = new MultivaluedMap<I, D>(){

            @Override
            protected List<D> newList() {
                return new DefaultResourceList();
            }
        };
        HashSet<Serializable> sourceIdSet = new HashSet<Serializable>();
        for (Serializable sourceId : sourceIds) {
            sourceIdSet.add(sourceId);
        }
        for (Object result : results) {
            this.handleTarget(bulkResult, result, sourceIdSet, oppositeField, sourceInformation);
        }
        return bulkResult;
    }

    private void handleTarget(MultivaluedMap<I, D> bulkResult, D result, Set<I> sourceIdSet, ResourceField oppositeField, ResourceInformation sourceInformation) {
        if (Collection.class.isAssignableFrom(oppositeField.getType())) {
            this.handleCollectionTarget(bulkResult, result, sourceIdSet, oppositeField, sourceInformation);
        } else {
            this.handleSingleTarget(bulkResult, result, sourceIdSet, oppositeField, sourceInformation);
        }
    }

    private void handleSingleTarget(MultivaluedMap<I, D> bulkResult, D result, Set<I> sourceIdSet, ResourceField oppositeField, ResourceInformation sourceInformation) {
        Serializable sourceId;
        if (oppositeField.hasIdField()) {
            ResourceFieldAccessor idAccessor = oppositeField.getIdAccessor();
            sourceId = (Serializable)idAccessor.getValue(result);
            if (sourceId == null) {
                throw new IllegalStateException("field " + oppositeField.getIdName() + "Id is null for " + result + ". To make use of opposite forwarding behavior for resource lookup, the opposite resource repository must return the relationship or its identifier based on @JsonApiRelationId ");
            }
        } else {
            Object source = oppositeField.getAccessor().getValue(result);
            if (source == null) {
                throw new IllegalStateException("field " + oppositeField.getUnderlyingName() + "Id is null for " + result + ". To make use of opposite forwarding behavior for resource lookup, the opposite resource repository must return the relationship or its identifier based on @JsonApiRelationId ");
            }
            sourceId = (Serializable)sourceInformation.getId(source);
            if (sourceId == null) {
                throw new IllegalStateException("id must not be null for resource " + source);
            }
        }
        PreconditionUtil.verify(sourceIdSet.contains(sourceId), "filtering not properly implemented in resource repository, expected sourceId=%s to be contained in %d", sourceId, sourceIdSet);
        bulkResult.add(sourceId, result);
    }

    private void handleCollectionTarget(MultivaluedMap<I, D> bulkResult, D result, Set<I> sourceIdSet, ResourceField oppositeField, ResourceInformation sourceInformation) {
        Collection<Serializable> sourceIds;
        if (oppositeField.hasIdField()) {
            ResourceFieldAccessor idAccessor = oppositeField.getIdAccessor();
            sourceIds = (Collection)idAccessor.getValue(result);
            if (sourceIds == null) {
                throw new IllegalStateException("field " + oppositeField.getIdName() + "Id is null for " + result + ". To make use of opposite forwarding behavior for resource lookup, the opposite resource repository must return the relationship or its identifier based on @JsonApiRelationId ");
            }
        } else {
            sourceIds = new ArrayList();
            Collection property = (Collection)oppositeField.getAccessor().getValue(result);
            if (property == null) {
                throw new IllegalStateException("field " + oppositeField.getUnderlyingName() + "Id is null for " + result + ". To make use of opposite forwarding behavior for resource lookup, the opposite resource repository must return the relationship or its identifier based on @JsonApiRelationId ");
            }
            for (Object potentialSource : property) {
                Serializable sourceId = (Serializable)sourceInformation.getId(potentialSource);
                if (sourceId == null) {
                    throw new IllegalStateException("id is null for " + potentialSource);
                }
                sourceIds.add(sourceId);
            }
        }
        for (Serializable sourceId : sourceIds) {
            if (!sourceIdSet.contains(sourceId)) continue;
            bulkResult.add(sourceId, result);
        }
    }
}

