/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.repository;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.repository.RelationshipMatcher;
import java.util.Objects;

public class RelationshipMatcherRule {
    protected final RelationshipMatcher matcher;
    protected String sourceResourceType;
    protected Class<?> sourceResourceClass;
    protected boolean sourceMatchSubTypes;
    protected String sourceField;
    protected String targetResourceType;
    protected Class<?> targetResourceClass;
    protected boolean targetMatchSubTypes;
    protected String targetField;

    protected RelationshipMatcherRule(RelationshipMatcher matcher) {
        this.matcher = matcher;
    }

    public RelationshipMatcherRule source(String sourceResourceType) {
        this.sourceResourceType = sourceResourceType;
        return this;
    }

    public RelationshipMatcherRule source(Class<?> sourceResourceClass) {
        return this.source(sourceResourceClass, false);
    }

    public RelationshipMatcherRule source(Class<?> sourceResourceClass, boolean sourceMatchSubTypes) {
        this.sourceResourceClass = sourceResourceClass;
        this.sourceMatchSubTypes = sourceMatchSubTypes;
        return this;
    }

    public RelationshipMatcherRule field(String sourceField) {
        this.sourceField = sourceField;
        return this;
    }

    public RelationshipMatcherRule field(ResourceField sourceField) {
        this.field(sourceField.getUnderlyingName());
        this.source(sourceField.getParentResourceInformation().getResourceType());
        return this;
    }

    public RelationshipMatcherRule target(String targetResourceType) {
        this.targetResourceType = targetResourceType;
        return this;
    }

    public RelationshipMatcherRule target(Class<?> targetResourceClass) {
        return this.target(targetResourceClass, false);
    }

    public RelationshipMatcherRule target(Class<?> targetResourceClass, boolean targetMatchSubTypes) {
        this.targetResourceClass = targetResourceClass;
        this.targetMatchSubTypes = targetMatchSubTypes;
        return this;
    }

    public RelationshipMatcherRule oppositeField(String targetField) {
        this.targetField = targetField;
        return this;
    }

    public RelationshipMatcher add() {
        this.matcher.rules.add(this);
        return this.matcher;
    }

    public boolean matches(ResourceField field) {
        boolean matchesSourceType = this.nullOrMatch(this.sourceResourceType, field.getParentResourceInformation().getResourceType());
        boolean matchesSourceClass = this.nullOrMatch(this.sourceResourceClass, field.getParentResourceInformation().getResourceClass(), this.sourceMatchSubTypes);
        boolean matchesSourceField = this.nullOrMatch(this.sourceField, field.getUnderlyingName());
        boolean matchesTargetType = this.nullOrMatch(this.targetResourceType, field.getOppositeResourceType());
        boolean matchesTargetClass = this.nullOrMatch(this.targetResourceClass, field.getElementType(), this.targetMatchSubTypes);
        boolean matchesTargetField = this.nullOrMatch(this.targetField, field.getOppositeName());
        return matchesSourceType && matchesSourceClass && matchesSourceField && matchesTargetType && matchesTargetClass && matchesTargetField;
    }

    private boolean nullOrMatch(String expected, String actual) {
        return expected == null || Objects.equals(expected, actual);
    }

    private boolean nullOrMatch(Class expected, Class actual, boolean matchSubTypes) {
        return expected == null || Objects.equals(expected, actual) || matchSubTypes && expected.isAssignableFrom(actual);
    }
}

