/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.pagingspec;

import io.crnk.core.engine.internal.utils.CompareUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingSpec;
import io.crnk.core.queryspec.pagingspec.PagingSpec;

public class NumberSizePagingSpec
implements PagingSpec {
    private Integer size = null;
    private int number = 1;

    public NumberSizePagingSpec() {
    }

    public NumberSizePagingSpec(int number, Integer size) {
        PreconditionUtil.verify(number > 0, "number=%s must be larger than zero", number);
        this.number = number;
        this.size = size;
    }

    public Integer getSize() {
        return this.size;
    }

    public NumberSizePagingSpec setSize(Integer size) {
        this.size = size;
        return this;
    }

    @Override
    public <T extends PagingSpec> T convert(Class<T> pagingSpecType) {
        if (pagingSpecType.equals(OffsetLimitPagingSpec.class)) {
            if (this.number == 1 && this.size == null) {
                return (T)new OffsetLimitPagingSpec(0L, null);
            }
            if (this.number == 1) {
                return (T)new OffsetLimitPagingSpec(0L, this.size.longValue());
            }
            if (this.number != 1 && this.size == null) {
                throw new UnsupportedOperationException("cannot use page number without page size");
            }
            return (T)new OffsetLimitPagingSpec(this.size.longValue() * (long)(this.number - 1), this.size.longValue());
        }
        throw new UnsupportedOperationException("cannot converted to " + pagingSpecType);
    }

    @Override
    public NumberSizePagingSpec clone() {
        return new NumberSizePagingSpec(this.number, this.size);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        result = 31 * result + Long.valueOf(this.number).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NumberSizePagingSpec other = (NumberSizePagingSpec)obj;
        return CompareUtils.isEquals(this.number, other.number) && CompareUtils.isEquals(this.size, other.size);
    }

    public String toString() {
        return "NumberSizePagingSpec[number=" + this.number + (this.size != null ? ", size=" + this.size : "") + ']';
    }

    public int getNumber() {
        return this.number;
    }

    public NumberSizePagingSpec setNumber(int number) {
        this.number = number;
        return this;
    }
}

