/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.mapper;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.exception.ParametersDeserializationException;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.mapper.QueryParameterType;
import java.util.List;
import java.util.Set;

public class QueryParameter {
    private String name;
    private QueryParameterType type;
    private String pagingType;
    private ResourceInformation resourceInformation;
    private FilterOperator operator;
    private List<String> attributePath;
    private Set<String> values;
    private TypeParser typeParser;

    public QueryParameter(TypeParser typeParser) {
        this.typeParser = typeParser;
    }

    public <T> T getValue(Class<T> type) {
        if (this.values.size() != 1) {
            throw new ParametersDeserializationException("expected a Long for " + this.toString());
        }
        try {
            String strValue = this.values.iterator().next();
            return this.typeParser.parse(strValue, type);
        }
        catch (NumberFormatException e) {
            throw new ParametersDeserializationException("expected a Long for " + this.toString());
        }
    }

    public String toString() {
        return this.name + "=" + this.values;
    }

    public String getName() {
        return this.name;
    }

    public QueryParameterType getType() {
        return this.type;
    }

    public ResourceInformation getResourceInformation() {
        return this.resourceInformation;
    }

    public FilterOperator getOperator() {
        return this.operator;
    }

    public List<String> getAttributePath() {
        return this.attributePath;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(QueryParameterType type) {
        this.type = type;
    }

    public void setValues(Set<String> values) {
        this.values = values;
    }

    public void setOperator(FilterOperator operator) {
        this.operator = operator;
    }

    public void setResourceInformation(ResourceInformation resourceInformation) {
        this.resourceInformation = resourceInformation;
    }

    public String getPagingType() {
        return this.pagingType;
    }

    public void setPagingType(String pageParameter) {
        this.pagingType = pageParameter;
    }

    public void setAttributePath(List<String> attributePath) {
        this.attributePath = attributePath;
    }
}

