/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.exception.ParametersDeserializationException;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.mapper.QueryPathResolver;
import io.crnk.core.queryspec.mapper.QueryPathSpec;
import io.crnk.core.queryspec.mapper.QuerySpecUrlContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JsonFilterSpecMapper {
    private final QuerySpecUrlContext context;
    private final Set<FilterOperator> supportedOperators;
    private final QueryPathResolver pathResolver;

    public JsonFilterSpecMapper(QuerySpecUrlContext ctx, Set<FilterOperator> supportedOperators, QueryPathResolver pathResolver) {
        this.context = ctx;
        this.supportedOperators = supportedOperators;
        this.pathResolver = pathResolver;
    }

    public List<FilterSpec> deserialize(JsonNode jsonNode, ResourceInformation resourceInformation) {
        return this.deserialize(jsonNode, resourceInformation, PathSpec.empty());
    }

    public boolean isJson(String value) {
        return value.startsWith("{") && value.endsWith("}") || value.startsWith("[") && value.endsWith("]");
    }

    public boolean isNested(List<FilterSpec> filterSpecs) {
        return filterSpecs.stream().filter(it -> it.hasExpressions()).findFirst().isPresent();
    }

    public JsonNode serialize(List<FilterSpec> filterSpecs) {
        return this.serialize(filterSpecs, FilterOperator.AND);
    }

    private JsonNode serialize(List<FilterSpec> filterSpecs, FilterOperator operator) {
        PreconditionUtil.verify(!filterSpecs.isEmpty(), "must not be empty", new Object[0]);
        ObjectMapper objectMapper = this.context.getObjectMapper();
        if (operator == FilterOperator.AND) {
            ObjectNode objectNode = objectMapper.createObjectNode();
            for (FilterSpec filterSpec : filterSpecs) {
                PathSpec path = filterSpec.getPath();
                if (!filterSpec.hasExpressions() && path.getElements().size() > 1) {
                    String firstPathElement = path.getElements().get(0);
                    FilterSpec nestedFilterSpec = filterSpec.clone();
                    nestedFilterSpec.setPath(PathSpec.of(path.getElements().subList(1, path.getElements().size())));
                    objectNode.set(firstPathElement, this.serializeFilter(nestedFilterSpec));
                    continue;
                }
                if (filterSpec.getOperator() == FilterOperator.EQ) {
                    JsonNode jsonNode = this.serializeValue(filterSpec.getValue());
                    objectNode.set(path.toString(), jsonNode);
                    continue;
                }
                if (filterSpec.hasExpressions()) {
                    objectNode.set(filterSpec.getOperator().toString(), this.serialize(filterSpec.getExpression(), filterSpec.getOperator()));
                    continue;
                }
                FilterSpec nestedFilterSpec = filterSpec.clone();
                nestedFilterSpec.setOperator(FilterOperator.EQ);
                objectNode.set(filterSpec.getOperator().toString(), this.serializeFilter(nestedFilterSpec));
            }
            return objectNode;
        }
        ArrayNode arrayNode = objectMapper.createArrayNode();
        filterSpecs.stream().forEach(it -> arrayNode.add(this.serializeFilter((FilterSpec)it)));
        return arrayNode;
    }

    private JsonNode serializeFilter(FilterSpec filterSpec) {
        return this.serialize(Arrays.asList(filterSpec));
    }

    private JsonNode serializeValue(Object value) {
        ObjectMapper objectMapper = this.context.getObjectMapper();
        return objectMapper.valueToTree(value);
    }

    private List<FilterSpec> deserialize(JsonNode jsonNode, ResourceInformation resourceInformation, PathSpec attributePath) {
        if (jsonNode instanceof ArrayNode) {
            return this.deserializeJsonArrayFilter((ArrayNode)jsonNode, resourceInformation, attributePath);
        }
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            ArrayList<FilterSpec> filterSpecs = new ArrayList<FilterSpec>();
            Iterator fieldNames = objectNode.fieldNames();
            while (fieldNames.hasNext()) {
                PathSpec nestedAttrPath;
                String fieldName = (String)fieldNames.next();
                JsonNode element = objectNode.get(fieldName);
                FilterOperator operator = this.findOperator(fieldName);
                if (operator != null) {
                    filterSpecs.add(this.deserializeJsonOperatorFilter(operator, element, resourceInformation, attributePath));
                    continue;
                }
                if (element instanceof ObjectNode) {
                    nestedAttrPath = attributePath.append(fieldName);
                    filterSpecs.add(FilterSpec.and(this.deserialize(element, resourceInformation, nestedAttrPath)));
                    continue;
                }
                nestedAttrPath = attributePath.append(fieldName);
                Object value = this.deserializeJsonFilterValue(resourceInformation, nestedAttrPath, element);
                filterSpecs.add(new FilterSpec(nestedAttrPath, FilterOperator.EQ, value));
            }
            return filterSpecs;
        }
        throw this.newParseException(jsonNode);
    }

    protected FilterOperator findOperator(String lastElement) {
        for (FilterOperator op : this.supportedOperators) {
            if (!op.getName().equalsIgnoreCase(lastElement)) continue;
            return op;
        }
        return null;
    }

    private Object deserializeJsonFilterValue(ResourceInformation resourceInformation, PathSpec attributePath, JsonNode jsonNode) {
        QueryPathSpec resolvedPath = this.pathResolver.resolve(resourceInformation, attributePath.getElements(), QueryPathResolver.NamingType.JSON, "filter");
        Class<?> valueType = ClassUtils.getRawType(resolvedPath.getValueType());
        ObjectReader reader = this.context.getObjectMapper().readerFor(valueType);
        try {
            if (jsonNode instanceof ArrayNode) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (JsonNode elementNode : jsonNode) {
                    values.add(reader.readValue(elementNode));
                }
                return values;
            }
            return reader.readValue(jsonNode);
        }
        catch (IOException e) {
            throw new ParametersDeserializationException("failed to parse value " + jsonNode + " to type " + valueType);
        }
    }

    private List<FilterSpec> deserializeJsonArrayFilter(ArrayNode arrayNode, ResourceInformation resourceInformation, PathSpec attributePath) {
        ArrayList<FilterSpec> filterSpecs = new ArrayList<FilterSpec>();
        for (int i = 0; i < arrayNode.size(); ++i) {
            filterSpecs.add(FilterSpec.and(this.deserialize(arrayNode.get(i), resourceInformation, attributePath)));
        }
        return filterSpecs;
    }

    private FilterSpec deserializeJsonOperatorFilter(FilterOperator operator, JsonNode element, ResourceInformation resourceInformation, PathSpec attributePath) {
        FilterSpec elementFilter;
        List<FilterSpec> elementFilters = this.deserialize(element, resourceInformation, attributePath);
        if (elementFilters.size() == 1 && (elementFilter = elementFilters.get(0)).getOperator() == FilterOperator.EQ) {
            if (operator == FilterOperator.NOT) {
                elementFilter.setOperator(FilterOperator.NEQ);
            } else {
                elementFilter.setOperator(operator);
            }
            return elementFilter;
        }
        return new FilterSpec(operator, elementFilters);
    }

    private RuntimeException newParseException(JsonNode jsonNode) {
        try {
            String text = this.context.getObjectMapper().writer().writeValueAsString((Object)jsonNode);
            throw new ParametersDeserializationException("failed to parse filter " + text);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

