/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.internal;

import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.information.bean.BeanAttributeInformation;
import io.crnk.core.engine.information.bean.BeanInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.queryspec.mapper.QueryPathResolver;
import io.crnk.core.queryspec.mapper.QueryPathSpec;
import io.crnk.core.queryspec.mapper.QuerySpecUrlContext;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DefaultQueryPathResolver
implements QueryPathResolver {
    private QuerySpecUrlContext ctx;
    private boolean allowUnknownAttributes = false;
    private boolean mapJsonNames = true;

    @Override
    public void init(QuerySpecUrlContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public QueryPathSpec resolve(ResourceInformation resourceInformation, List<String> attributePath, QueryPathResolver.NamingType sourceNamingType, String sourceParameter) {
        if (attributePath == null) {
            return new QueryPathSpec((Type)((Object)String.class), null);
        }
        ResourceRegistry resourceRegistry = this.ctx.getResourceRegistry();
        Object valueType = resourceInformation.getResourceClass();
        SubTypeMap subTypeMap = null;
        ArrayList<String> targetPath = new ArrayList<String>();
        for (String sourceAttributePath : attributePath) {
            if (resourceInformation != null) {
                ResourceField field;
                ResourceField resourceField = field = sourceNamingType == QueryPathResolver.NamingType.JSON ? resourceInformation.findFieldByName(sourceAttributePath) : resourceInformation.findFieldByUnderlyingName(sourceAttributePath);
                if (field == null) {
                    if (subTypeMap == null) {
                        subTypeMap = new SubTypeMap(resourceRegistry);
                    }
                    List<ResourceInformation> subTypes = subTypeMap.findSubTypes(resourceInformation.getResourceType());
                    for (ResourceInformation subType : subTypes) {
                        field = sourceNamingType == QueryPathResolver.NamingType.JSON ? subType.findFieldByName(sourceAttributePath) : subType.findFieldByUnderlyingName(sourceAttributePath);
                        if (field == null) continue;
                        break;
                    }
                }
                if (field != null) {
                    if (field.getResourceFieldType() == ResourceFieldType.RELATIONSHIP) {
                        RegistryEntry entry = resourceRegistry.getEntry(field.getOppositeResourceType());
                        PreconditionUtil.verify(entry != null, "resourceType=%s not found for field=%s", field.getOppositeResourceType(), field.getUnderlyingName());
                        resourceInformation = entry.getResourceInformation();
                        valueType = resourceInformation.getResourceClass();
                    } else {
                        resourceInformation = null;
                        valueType = field.getElementType();
                    }
                    targetPath.add(sourceNamingType == QueryPathResolver.NamingType.JSON ? field.getUnderlyingName() : field.getJsonName());
                    continue;
                }
            } else {
                BeanAttributeInformation attribute;
                resourceInformation = null;
                if (valueType == Object.class) {
                    targetPath.add(sourceAttributePath);
                    continue;
                }
                if (Map.class.isAssignableFrom(ClassUtils.getRawType(valueType))) {
                    valueType = valueType instanceof ParameterizedType ? ((ParameterizedType)valueType).getActualTypeArguments()[1] : Object.class;
                    targetPath.add(sourceAttributePath);
                    continue;
                }
                BeanInformation beanInformation = BeanInformation.get(ClassUtils.getRawType(valueType));
                BeanAttributeInformation beanAttributeInformation = attribute = sourceNamingType == QueryPathResolver.NamingType.JSON ? beanInformation.getAttributeByJsonName(sourceAttributePath) : beanInformation.getAttribute(sourceAttributePath);
                if (attribute != null) {
                    valueType = attribute.getImplementationType();
                    targetPath.add(sourceNamingType == QueryPathResolver.NamingType.JSON ? attribute.getName() : attribute.getJsonName());
                    continue;
                }
            }
            if (this.allowUnknownAttributes) {
                targetPath.add(sourceAttributePath);
                valueType = Object.class;
                continue;
            }
            ErrorData errorData = ErrorData.builder().setCode("UNKNOWN_PARAMETER").setTitle("unknown parameter").setDetail("Failed to resolve path to field '" + StringUtils.join(".", attributePath) + "'").setSourceParameter(sourceParameter).setStatus(String.valueOf(400)).build();
            throw new BadRequestException(400, errorData);
        }
        ArrayList<String> path = this.mapJsonNames ? targetPath : attributePath;
        return new QueryPathSpec((Type)valueType, (List<String>)path);
    }

    @Override
    public boolean getAllowUnknownAttributes() {
        return this.allowUnknownAttributes;
    }

    @Override
    public void setAllowUnknownAttributes(boolean allowUnknownAttributes) {
        this.allowUnknownAttributes = allowUnknownAttributes;
    }

    @Override
    public boolean getMapJsonNames() {
        return this.mapJsonNames;
    }

    @Override
    public void setMapJsonNames(boolean mapJsonNames) {
        this.mapJsonNames = mapJsonNames;
    }

    class SubTypeMap {
        private MultivaluedMap<String, ResourceInformation> mapping = new MultivaluedMap();

        public SubTypeMap(ResourceRegistry resourceRegistry) {
            Collection<RegistryEntry> entries = resourceRegistry.getResources();
            for (RegistryEntry entry : entries) {
                ResourceInformation resourceInformation = entry.getResourceInformation();
                String superResourceType = resourceInformation.getSuperResourceType();
                if (superResourceType == null) continue;
                this.mapping.add(superResourceType, resourceInformation);
            }
        }

        public List<ResourceInformation> findSubTypes(String resourceType) {
            ArrayList<ResourceInformation> results = new ArrayList<ResourceInformation>();
            this.findSubTypes(results, resourceType);
            return results;
        }

        private void findSubTypes(List<ResourceInformation> results, String resourceType) {
            if (this.mapping.containsKey(resourceType)) {
                List<ResourceInformation> children = this.mapping.getList(resourceType);
                for (ResourceInformation child : children) {
                    results.add(child);
                }
                for (ResourceInformation child : children) {
                    this.findSubTypes(results, child.getResourceType());
                }
            }
        }
    }
}

