/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.PropertyException;
import io.crnk.core.engine.internal.utils.PropertyUtils;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.resource.meta.DefaultPagedMetaInformation;
import io.crnk.core.resource.meta.HasMoreResourcesMetaInformation;
import io.crnk.core.resource.meta.MetaInformation;
import io.crnk.core.resource.meta.PagedMetaInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class InMemoryEvaluator {
    private ResourceRegistry resourceRegistry;

    public InMemoryEvaluator() {
    }

    public InMemoryEvaluator(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }

    public static boolean matches(Object object, FilterSpec filterSpec) {
        InMemoryEvaluator evaluator = new InMemoryEvaluator();
        return evaluator.matchesFilter(object, filterSpec);
    }

    public boolean matchesFilter(Object object, FilterSpec filterSpec) {
        List<FilterSpec> expressions = filterSpec.getExpression();
        if (expressions == null) {
            return this.matchesPrimitiveOperator(object, filterSpec);
        }
        if (filterSpec.getOperator() == FilterOperator.OR) {
            return this.matchesOr(object, expressions);
        }
        if (filterSpec.getOperator() == FilterOperator.AND) {
            return this.matchesAnd(object, expressions);
        }
        if (filterSpec.getOperator() == FilterOperator.NOT) {
            return !this.matchesFilter(object, FilterSpec.and(expressions));
        }
        throw new UnsupportedOperationException("not implemented " + filterSpec);
    }

    protected boolean matchesPrimitiveOperator(Object object, FilterSpec filterSpec) {
        if (filterSpec.getAttributePath() == null) {
            throw new BadRequestException("no attribute specified for filter parameter");
        }
        Object value = this.getProperty(object, filterSpec.getAttributePath());
        FilterOperator operator = filterSpec.getOperator();
        Object filterValue = filterSpec.getValue();
        if (value instanceof Collection) {
            return this.matchesAny((Collection)value, operator, filterValue);
        }
        return operator.matches(value, filterValue);
    }

    protected Object getProperty(Object object, List<String> pathElements) {
        if (pathElements.isEmpty()) {
            return object;
        }
        Class<?> clazz = object.getClass();
        if (this.resourceRegistry != null && this.resourceRegistry.hasEntry(clazz)) {
            return this.getResourceProperty(object, pathElements);
        }
        Object value = PropertyUtils.getProperty(object, pathElements);
        int pathLength = pathElements.size();
        if (value == null && pathLength >= 2 && pathElements.get(pathLength - 1).equals("id")) {
            ArrayList<String> idAttributePath = new ArrayList<String>(pathElements.subList(0, pathLength - 2));
            idAttributePath.add(pathElements.get(pathLength - 2) + "Id");
            try {
                return PropertyUtils.getProperty(object, idAttributePath);
            }
            catch (PropertyException e) {
                return null;
            }
        }
        return value;
    }

    private Object getResourceProperty(Object object, List<String> pathElements) {
        RegistryEntry oppositeEntry;
        ResourceField idField;
        String secondPathElement;
        boolean isRelationship;
        Class<?> clazz = object.getClass();
        RegistryEntry entry = this.resourceRegistry.getEntry(clazz);
        ResourceInformation resourceInformation = entry.getResourceInformation();
        int consumedElements = 1;
        String firstPathElement = pathElements.get(0);
        ResourceField resourceField = resourceInformation.findFieldByUnderlyingName(firstPathElement);
        PreconditionUtil.verify(resourceField != null, "resource field %s in %s not found", firstPathElement, clazz);
        Object value = resourceField.getAccessor().getValue(object);
        boolean bl = isRelationship = resourceField.getResourceFieldType() == ResourceFieldType.RELATIONSHIP;
        if (value == null && pathElements.size() >= 2 && isRelationship && resourceField.hasIdField() && (secondPathElement = pathElements.get(1)).equals((idField = (oppositeEntry = this.resourceRegistry.getEntry(resourceField.getOppositeResourceType())).getResourceInformation().getIdField()).getUnderlyingName())) {
            value = resourceField.getIdAccessor().getValue(object);
            ++consumedElements;
        }
        List<String> childElements = pathElements.subList(consumedElements, pathElements.size());
        return this.getProperty(value, childElements);
    }

    protected boolean matchesAny(Collection<?> col, FilterOperator operator, Object filterValue) {
        for (Object elem : col) {
            boolean matches = operator.matches(elem, filterValue);
            if (!matches) continue;
            return true;
        }
        return false;
    }

    protected boolean matchesOr(Object object, List<FilterSpec> expressions) {
        for (FilterSpec expr : expressions) {
            if (!this.matchesFilter(object, expr)) continue;
            return true;
        }
        return false;
    }

    protected boolean matchesAnd(Object object, List<FilterSpec> expressions) {
        for (FilterSpec expr : expressions) {
            if (this.matchesFilter(object, expr)) continue;
            return false;
        }
        return true;
    }

    public <T> ResourceList<T> eval(Iterable<T> resources, QuerySpec querySpec) {
        DefaultResourceList resultList = new DefaultResourceList();
        resultList.setMeta(new DefaultPagedMetaInformation());
        this.eval(resources, querySpec, resultList);
        return resultList;
    }

    public <T> void eval(Iterable<T> resources, QuerySpec querySpec, ResourceList<T> resultList) {
        Iterator<T> iterator = resources.iterator();
        while (iterator.hasNext()) {
            resultList.add(iterator.next());
        }
        if (!querySpec.getFilters().isEmpty()) {
            FilterSpec filterSpec = FilterSpec.and(querySpec.getFilters());
            this.applyFilter(resultList, filterSpec);
        }
        long totalCount = resultList.size();
        this.applySorting(resultList, querySpec.getSort());
        this.applyPaging(resultList, querySpec);
        if (querySpec.getLimit() != null || querySpec.getOffset() != 0L) {
            MetaInformation pagedMeta;
            MetaInformation meta = resultList.getMeta();
            if (meta instanceof PagedMetaInformation) {
                pagedMeta = (PagedMetaInformation)meta;
                pagedMeta.setTotalResourceCount(totalCount);
            }
            if (meta instanceof HasMoreResourcesMetaInformation) {
                pagedMeta = (HasMoreResourcesMetaInformation)meta;
                pagedMeta.setHasMoreResources(totalCount > querySpec.getOffset() + querySpec.getLimit());
            }
        }
    }

    protected <T> void applySorting(List<T> results, List<SortSpec> sortSpec) {
        if (!sortSpec.isEmpty()) {
            Collections.sort(results, new SortSpecComparator(sortSpec));
        }
    }

    protected <T> void applyPaging(List<T> results, QuerySpec querySpec) {
        int offset = (int)Math.min(querySpec.getOffset(), Integer.MAX_VALUE);
        int limit = (int)Math.min(Integer.MAX_VALUE, querySpec.getLimit() != null ? querySpec.getLimit() : Integer.MAX_VALUE);
        if (offset > results.size()) {
            throw new BadRequestException("page offset out of range, cannot move beyond data set");
        }
        limit = Math.min(results.size() - offset, limit);
        if (offset > 0 || limit < results.size()) {
            ArrayList<T> subList = new ArrayList<T>(results.subList(offset, offset + limit));
            results.clear();
            results.addAll(subList);
        }
    }

    protected <T> void applyFilter(List<T> results, FilterSpec filterSpec) {
        if (filterSpec != null) {
            Iterator<T> iterator = results.iterator();
            while (iterator.hasNext()) {
                T next = iterator.next();
                if (this.matchesFilter(next, filterSpec)) continue;
                iterator.remove();
            }
        }
    }

    class SortSpecComparator<T>
    implements Comparator<T> {
        private List<SortSpec> sortSpecs;

        public SortSpecComparator(List<SortSpec> sortSpecs) {
            this.sortSpecs = sortSpecs;
        }

        @Override
        public int compare(T o1, T o2) {
            for (SortSpec orderSpec : this.sortSpecs) {
                Comparable value1 = (Comparable)InMemoryEvaluator.this.getProperty(o1, orderSpec.getAttributePath());
                Comparable value2 = (Comparable)InMemoryEvaluator.this.getProperty(o2, orderSpec.getAttributePath());
                int d = this.compare(value1, value2);
                if (orderSpec.getDirection() == Direction.DESC) {
                    d = -d;
                }
                if (d == 0) continue;
                return d;
            }
            return 0;
        }

        @Override
        private int compare(Comparable<Object> value1, Comparable<Object> value2) {
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null) {
                return -1;
            }
            if (value2 == null) {
                return 1;
            }
            return value1.compareTo(value2);
        }
    }
}

