/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.crnk.core.engine.internal.utils.CompareUtils;
import io.crnk.core.queryspec.AbstractPathSpec;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.PathSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FilterSpec
extends AbstractPathSpec
implements Comparable<FilterSpec> {
    @JsonSerialize(using=ToStringSerializer.class)
    private FilterOperator operator;
    private Object value;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<FilterSpec> expressions;

    protected FilterSpec() {
    }

    FilterSpec(FilterSpec spec) {
        super(spec.getPath() != null ? spec.getPath().clone() : null);
        this.operator = spec.operator;
        this.value = spec.value;
        if (spec.expressions != null) {
            this.expressions = FilterSpec.cloneExpressions(spec.expressions, false);
        }
    }

    public FilterSpec(Object value) {
        this.value = value;
    }

    public FilterSpec(FilterOperator operator, List<FilterSpec> expressions) {
        this.operator = operator;
        this.expressions = expressions;
    }

    public FilterSpec(List<String> attributePath, FilterOperator operator, Object value) {
        this(PathSpec.of(attributePath), operator, value);
    }

    public FilterSpec(PathSpec path, FilterOperator operator, Object value) {
        super(path);
        this.operator = operator;
        this.value = value;
        this.assertOperator();
        this.assertNotExpressions();
    }

    private FilterSpec(PathSpec pathSpec, FilterOperator operator, Object value, List<FilterSpec> expressions) {
        super(pathSpec);
        this.operator = operator;
        this.value = value;
        this.expressions = expressions;
    }

    public static FilterSpec and(Collection<FilterSpec> conditions) {
        return FilterSpec.and(conditions.toArray(new FilterSpec[conditions.size()]));
    }

    public static FilterSpec and(FilterSpec ... conditions) {
        if (conditions.length == 1) {
            return conditions[0];
        }
        FilterSpec ret = new FilterSpec();
        ret.setOperator(FilterOperator.AND);
        for (FilterSpec c : conditions) {
            ret.addExpression(c);
        }
        return ret;
    }

    public static FilterSpec or(Collection<FilterSpec> conditions) {
        return FilterSpec.or(conditions.toArray(new FilterSpec[conditions.size()]));
    }

    public static FilterSpec or(FilterSpec ... conditions) {
        if (conditions.length == 1) {
            return conditions[0];
        }
        FilterSpec ret = new FilterSpec();
        ret.setOperator(FilterOperator.OR);
        for (FilterSpec c : conditions) {
            ret.addExpression(c);
        }
        return ret;
    }

    public static FilterSpec not(FilterSpec expression) {
        FilterSpec ret = new FilterSpec();
        ret.setOperator(FilterOperator.NOT);
        ret.addExpression(expression);
        return ret;
    }

    static List<FilterSpec> cloneExpressions(List<FilterSpec> list, boolean normalize) {
        ArrayList<FilterSpec> result = new ArrayList<FilterSpec>();
        for (FilterSpec spec : list) {
            if (normalize) {
                result.add(spec.normalize());
                continue;
            }
            result.add(spec.clone());
        }
        if (normalize) {
            Collections.sort(result);
        }
        return result;
    }

    private void assertOperator() {
        if (this.operator == null) {
            throw new IllegalArgumentException("Condition required");
        }
    }

    private void assertNotExpressions() {
        if (this.operator == FilterOperator.NOT) {
            throw new IllegalArgumentException("NOT operator not allowed when comparing with a value, use NOT_EQUAL");
        }
        if (this.operator == FilterOperator.AND || this.operator == FilterOperator.OR) {
            throw new IllegalArgumentException(this.operator + " operator not allowed when comparing with a value");
        }
    }

    public FilterOperator getOperator() {
        return this.operator;
    }

    public void setOperator(FilterOperator operator) {
        this.operator = operator;
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public List<FilterSpec> getExpression() {
        return this.expressions;
    }

    public FilterSpec addExpression(FilterSpec expr) {
        if (this.expressions == null) {
            this.expressions = new ArrayList<FilterSpec>();
        }
        this.expressions.add(expr);
        return this;
    }

    public boolean hasExpressions() {
        return this.expressions != null && !this.expressions.isEmpty();
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.getAttributePath(), this.operator, this.expressions, this.value});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FilterSpec other = (FilterSpec)obj;
        return CompareUtils.isEquals(this.path, other.path) && CompareUtils.isEquals(this.operator, other.operator) && CompareUtils.isEquals(this.value, other.value) && CompareUtils.isEquals(this.expressions, other.expressions);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.getExpression() != null) {
            int nExprs = this.getExpression().size();
            if (this.getOperator() == FilterOperator.NOT) {
                this.appendNot(b, nExprs);
            } else {
                this.appendExpressions(b, nExprs);
            }
        } else if (this.path != null) {
            b.append(this.path);
            b.append(' ');
            b.append(this.operator.name());
            b.append(' ');
            b.append(this.value);
        }
        return b.toString();
    }

    private void appendExpressions(StringBuilder b, int nExprs) {
        for (int i = 0; i < nExprs; ++i) {
            if (i > 0) {
                b.append(' ');
                b.append(this.getOperator());
                b.append(' ');
            }
            b.append('(');
            b.append(this.getExpression().get(i));
            b.append(')');
        }
    }

    private void appendNot(StringBuilder b, int nExprs) {
        b.append("NOT");
        if (nExprs > 1) {
            b.append('(');
        }
        for (int i = 0; i < nExprs; ++i) {
            if (i > 0) {
                b.append(" AND ");
            }
            b.append('(');
            b.append(this.getExpression().get(i));
            b.append(')');
        }
        if (nExprs > 1) {
            b.append(')');
        }
    }

    public FilterSpec normalize() {
        List<FilterSpec> clonedExpressions = this.expressions != null ? FilterSpec.cloneExpressions(this.expressions, true) : null;
        FilterSpec copy = new FilterSpec(this.path, this.operator, this.value, clonedExpressions);
        return copy;
    }

    public FilterSpec clone() {
        return new FilterSpec(this);
    }

    @Override
    public int compareTo(FilterSpec o) {
        return this.toString().compareTo(o.toString());
    }
}

