/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.module.internal;

import io.crnk.core.engine.filter.FilterBehavior;
import io.crnk.core.engine.filter.ResourceFilter;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.ForbiddenException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFilterDirectoryImpl
implements ResourceFilterDirectory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceFilterDirectoryImpl.class);
    private final List<ResourceFilter> filters;
    private final HttpRequestContextProvider requestContextProvider;
    private final ResourceRegistry resourceRegistry;

    public ResourceFilterDirectoryImpl(List<ResourceFilter> filters, HttpRequestContextProvider requestContextProvider, ResourceRegistry resourceRegistry) {
        this.filters = filters;
        this.requestContextProvider = requestContextProvider;
        this.resourceRegistry = resourceRegistry;
    }

    @Override
    public FilterBehavior get(ResourceInformation resourceInformation, HttpMethod method, QueryContext queryContext) {
        ResourceFilter filter;
        FilterBehavior behavior;
        Map<Object, FilterBehavior> map = this.getCache(method, queryContext);
        if (queryContext != null && (behavior = map.get(resourceInformation)) != null) {
            return behavior;
        }
        behavior = FilterBehavior.NONE;
        Iterator<ResourceFilter> iterator = this.filters.iterator();
        while (iterator.hasNext() && (behavior = behavior.merge((filter = iterator.next()).filterResource(resourceInformation, method))) != FilterBehavior.FORBIDDEN) {
        }
        if (queryContext != null) {
            map.put(resourceInformation, behavior);
        }
        return behavior;
    }

    @Override
    public FilterBehavior get(ResourceField field, HttpMethod method, QueryContext queryContext) {
        ResourceFilter filter;
        Map<Object, FilterBehavior> map = this.getCache(method, queryContext);
        FilterBehavior behavior = map.get(field);
        if (behavior != null) {
            return behavior;
        }
        boolean modifiable = field.getAccess().allows(method);
        behavior = modifiable ? FilterBehavior.NONE : FilterBehavior.IGNORED;
        Iterator<ResourceFilter> iterator = this.filters.iterator();
        while (iterator.hasNext() && (behavior = behavior.merge((filter = iterator.next()).filterField(field, method))) != FilterBehavior.FORBIDDEN) {
        }
        if (field.getResourceFieldType() == ResourceFieldType.RELATIONSHIP) {
            String oppositeResourceType = field.getOppositeResourceType();
            RegistryEntry oppositeRegistryEntry = this.resourceRegistry.getEntry(oppositeResourceType);
            if (oppositeRegistryEntry != null) {
                ResourceInformation oppositeResourceInformation = oppositeRegistryEntry.getResourceInformation();
                behavior = behavior.merge(this.get(oppositeResourceInformation, HttpMethod.GET, queryContext));
            } else {
                LOGGER.warn("opposite side {} not found", (Object)oppositeResourceType);
            }
        }
        map.put(field, behavior);
        return behavior;
    }

    private Map<Object, FilterBehavior> getCache(HttpMethod method, QueryContext queryContext) {
        if (queryContext == null) {
            return null;
        }
        String key = ResourceFilterDirectoryImpl.class.getSimpleName() + (Object)((Object)method);
        ConcurrentHashMap cache = (ConcurrentHashMap)queryContext.getAttribute(key);
        if (cache == null) {
            cache = new ConcurrentHashMap();
            queryContext.setAttribute(key, cache);
        }
        return cache;
    }

    @Override
    public boolean canAccess(ResourceField field, HttpMethod method, QueryContext queryContext, boolean allowIgnore) {
        if (field == null) {
            return true;
        }
        FilterBehavior filterBehavior = this.get(field, method, queryContext);
        if (filterBehavior == FilterBehavior.NONE) {
            return true;
        }
        if (filterBehavior == FilterBehavior.FORBIDDEN || !allowIgnore) {
            String resourceType = field.getParentResourceInformation().getResourceType();
            throw new ForbiddenException("field '" + resourceType + "." + field.getJsonName() + "' cannot be accessed for " + (Object)((Object)method));
        }
        LOGGER.debug("ignoring field {}", (Object)field.getUnderlyingName());
        PreconditionUtil.verifyEquals((Object)FilterBehavior.IGNORED, (Object)filterBehavior, "unknown behavior", new Object[0]);
        return false;
    }
}

