/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.module;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.dispatcher.RequestDispatcher;
import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.error.JsonApiExceptionMapper;
import io.crnk.core.engine.filter.DocumentFilter;
import io.crnk.core.engine.filter.RepositoryFilter;
import io.crnk.core.engine.filter.ResourceFilter;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.filter.ResourceModificationFilter;
import io.crnk.core.engine.http.HttpRequestContextAware;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.http.HttpRequestProcessor;
import io.crnk.core.engine.information.contributor.ResourceFieldContributor;
import io.crnk.core.engine.information.repository.RepositoryInformation;
import io.crnk.core.engine.information.repository.RepositoryInformationProvider;
import io.crnk.core.engine.information.repository.RepositoryInformationProviderContext;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceInformationProvider;
import io.crnk.core.engine.information.resource.ResourceInformationProviderContext;
import io.crnk.core.engine.internal.dispatcher.ControllerRegistry;
import io.crnk.core.engine.internal.exception.ExceptionMapperLookup;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistryBuilder;
import io.crnk.core.engine.internal.information.DefaultInformationBuilder;
import io.crnk.core.engine.internal.registry.DefaultRegistryEntryBuilder;
import io.crnk.core.engine.internal.repository.RepositoryAdapterFactory;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.NullPropertiesProvider;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapterBuilder;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.RegistryEntryBuilder;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryPart;
import io.crnk.core.engine.result.ImmediateResultFactory;
import io.crnk.core.engine.result.ResultFactory;
import io.crnk.core.engine.security.SecurityProvider;
import io.crnk.core.module.InitializingModule;
import io.crnk.core.module.Module;
import io.crnk.core.module.ModuleExtension;
import io.crnk.core.module.ModuleExtensionAware;
import io.crnk.core.module.SimpleModule;
import io.crnk.core.module.discovery.MultiResourceLookup;
import io.crnk.core.module.discovery.ResourceLookup;
import io.crnk.core.module.discovery.ServiceDiscovery;
import io.crnk.core.module.internal.ResourceFilterDirectoryImpl;
import io.crnk.core.queryspec.mapper.QuerySpecUrlContext;
import io.crnk.core.queryspec.mapper.QuerySpecUrlMapper;
import io.crnk.core.queryspec.pagingspec.PagingBehavior;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.core.repository.decorate.RelationshipRepositoryDecorator;
import io.crnk.core.repository.decorate.RepositoryDecoratorFactory;
import io.crnk.core.repository.decorate.ResourceRepositoryDecorator;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.utils.Prioritizable;
import io.crnk.legacy.registry.DefaultResourceInformationProviderContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleRegistry.class);
    private ResultFactory resultFactory;
    private Map<String, String> serverInfo;
    private TypeParser typeParser = new TypeParser();
    private ObjectMapper objectMapper;
    private ResourceRegistry resourceRegistry;
    private QuerySpecUrlMapper urlMapper;
    private List<Module> modules = new ArrayList<Module>();
    private SimpleModule aggregatedModule = new SimpleModule(null);
    private volatile InitializedState initializedState = InitializedState.NOT_INITIALIZED;
    private ResourceInformationProvider resourceInformationProvider;
    private ServiceDiscovery serviceDiscovery;
    private boolean isServer = true;
    private ExceptionMapperRegistry exceptionMapperRegistry;
    private RequestDispatcher requestDispatcher;
    private HttpRequestContextProvider httpRequestContextProvider = new HttpRequestContextProvider(() -> this.getResultFactory());
    private PropertiesProvider propertiesProvider = new NullPropertiesProvider();
    private ResourceFilterDirectory filterBehaviorProvider;
    private ControllerRegistry controllerRegistry;
    private QueryAdapterBuilder queryAdapterBuilder;
    private MultivaluedMap<Module, ModuleExtension> extensionMap = new MultivaluedMap();

    public ModuleRegistry() {
        this(true);
    }

    public ModuleRegistry(boolean isServer) {
        this.isServer = isServer;
    }

    @Deprecated
    public QueryAdapterBuilder getQueryAdapterBuilder() {
        return this.queryAdapterBuilder;
    }

    @Deprecated
    public void setQueryAdapterBuilder(QueryAdapterBuilder queryAdapterBuilder) {
        this.queryAdapterBuilder = queryAdapterBuilder;
    }

    @Deprecated
    public ControllerRegistry getControllerRegistry() {
        return this.controllerRegistry;
    }

    @Deprecated
    public void setControllerRegistry(ControllerRegistry controllerRegistry) {
        this.controllerRegistry = controllerRegistry;
    }

    public DefaultInformationBuilder getInformationBuilder() {
        return new DefaultInformationBuilder(this.typeParser);
    }

    public List<ResourceModificationFilter> getResourceModificationFilters() {
        return Prioritizable.prioritze(this.aggregatedModule.getResourceModificationFilters());
    }

    public void setServerInfo(Map<String, String> serverInfo) {
        this.serverInfo = serverInfo;
    }

    public Map<String, String> getServerInfo() {
        return this.serverInfo;
    }

    public ResultFactory getResultFactory() {
        if (this.resultFactory == null) {
            throw new IllegalStateException("resultFactory not yet available");
        }
        return this.resultFactory;
    }

    public Collection<Object> getRepositories() {
        return this.aggregatedModule.getRepositories();
    }

    public void setResultFactory(ResultFactory resultFactory) {
        if (this.resultFactory != null) {
            throw new IllegalStateException("already set to " + this.resultFactory);
        }
        this.resultFactory = resultFactory;
    }

    public void addModule(Module module) {
        LOGGER.debug("adding module {}", (Object)module);
        module.setupModule(new ModuleContextImpl(module));
        this.modules.add(module);
    }

    public void addPagingBehavior(PagingBehavior pagingBehavior) {
        this.aggregatedModule.addPagingBehavior(pagingBehavior);
    }

    public void addAllPagingBehaviors(List<PagingBehavior> pagingBehaviors) {
        for (PagingBehavior pagingBehavior : pagingBehaviors) {
            this.aggregatedModule.addPagingBehavior(pagingBehavior);
        }
    }

    public List<PagingBehavior> getPagingBehaviors() {
        return this.aggregatedModule.getPagingBehaviors();
    }

    public List<ResourceFieldContributor> getResourceFieldContributors() {
        return this.aggregatedModule.getResourceFieldContributors();
    }

    public ResourceRegistry getResourceRegistry() {
        if (this.resourceRegistry == null) {
            throw new IllegalStateException("resourceRegistry not yet available");
        }
        return this.resourceRegistry;
    }

    public void setResourceRegistry(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }

    public void setRequestDispatcher(RequestDispatcher requestDispatcher) {
        this.requestDispatcher = requestDispatcher;
    }

    public List<com.fasterxml.jackson.databind.Module> getJacksonModules() {
        return this.aggregatedModule.getJacksonModules();
    }

    protected void checkState(InitializedState minState, InitializedState maxState) {
        PreconditionUtil.verify(this.initializedState.ordinal() >= minState.ordinal(), "not yet initialized, cannot yet be called", new Object[0]);
        PreconditionUtil.verify(this.initializedState.ordinal() <= maxState.ordinal(), "already initialized, cannot be called anymore", new Object[0]);
    }

    public ResourceInformationProvider getResourceInformationBuilder() {
        if (this.resourceInformationProvider == null) {
            this.resourceInformationProvider = new CombinedResourceInformationProvider(Prioritizable.prioritze(this.aggregatedModule.getResourceInformationProviders()));
            DefaultInformationBuilder informationBuilder = new DefaultInformationBuilder(this.typeParser);
            DefaultResourceInformationProviderContext context = new DefaultResourceInformationProviderContext(this.resourceInformationProvider, informationBuilder, this.typeParser, this.objectMapper);
            this.resourceInformationProvider.init(context);
        }
        return this.resourceInformationProvider;
    }

    public RepositoryInformationProvider getRepositoryInformationBuilder() {
        return new CombinedRepositoryInformationProvider(this.aggregatedModule.getRepositoryInformationProviders());
    }

    public ResourceLookup getResourceLookup() {
        this.checkState(InitializedState.INITIALIZING, InitializedState.INITIALIZED);
        return new MultiResourceLookup(this.aggregatedModule.getResourceLookups());
    }

    public List<HttpRequestProcessor> getHttpRequestProcessors() {
        this.checkState(InitializedState.INITIALIZED, InitializedState.INITIALIZED);
        return Prioritizable.prioritze(this.aggregatedModule.getHttpRequestProcessors());
    }

    public SecurityProvider getSecurityProvider() {
        this.checkState(InitializedState.INITIALIZED, InitializedState.INITIALIZED);
        List<SecurityProvider> securityProviders = this.aggregatedModule.getSecurityProviders();
        return new AggregatedSecurityProvider(securityProviders);
    }

    public List<SecurityProvider> getSecurityProviders() {
        return this.aggregatedModule.getSecurityProviders();
    }

    public ServiceDiscovery getServiceDiscovery() {
        PreconditionUtil.verify(this.serviceDiscovery != null, "serviceDiscovery not yet available", new Object[0]);
        return this.serviceDiscovery;
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public PropertiesProvider getPropertiesProvider() {
        return this.propertiesProvider;
    }

    public void setPropertiesProvider(PropertiesProvider propertiesProvider) {
        this.propertiesProvider = propertiesProvider;
    }

    public void init(ObjectMapper objectMapper) {
        if (this.resultFactory == null) {
            this.resultFactory = new ImmediateResultFactory();
        }
        PreconditionUtil.verifyEquals((Object)InitializedState.NOT_INITIALIZED, (Object)this.initializedState, "already initialized", new Object[0]);
        this.initializedState = InitializedState.INITIALIZING;
        this.objectMapper = objectMapper;
        this.objectMapper.registerModules(this.getJacksonModules());
        this.typeParser.setObjectMapper(objectMapper);
        this.initializeModules();
        if (this.isServer) {
            this.applyRepositoryRegistrations();
            this.applyResourceRegistrations();
        }
        ExceptionMapperLookup exceptionMapperLookup = this.getExceptionMapperLookup();
        ExceptionMapperRegistryBuilder mapperRegistryBuilder = new ExceptionMapperRegistryBuilder();
        this.exceptionMapperRegistry = mapperRegistryBuilder.build(exceptionMapperLookup);
        this.filterBehaviorProvider = new ResourceFilterDirectoryImpl(this.aggregatedModule.getResourceFilters(), this.httpRequestContextProvider, this.resourceRegistry);
        this.initializedState = InitializedState.INITIALIZED;
    }

    private void initializeModules() {
        this.setExtensions();
        HashSet<Module> initializedModules = new HashSet<Module>();
        for (Module module : this.modules) {
            this.initializeModule(module, initializedModules);
        }
    }

    private void setExtensions() {
        MultivaluedMap<Module, ModuleExtension> reverseExtensionMap = new MultivaluedMap<Module, ModuleExtension>();
        for (ModuleExtension extension : this.aggregatedModule.getExtensions()) {
            Optional<? extends Module> optModule = this.getModule(extension.getTargetModule());
            if (optModule.isPresent()) {
                reverseExtensionMap.add(optModule.get(), extension);
                continue;
            }
            if (extension.isOptional()) continue;
            throw new IllegalStateException(extension.getTargetModule() + " not installed but required by " + extension);
        }
        for (Module extendedModule : reverseExtensionMap.keySet()) {
            List extensions = reverseExtensionMap.getList(extendedModule);
            PreconditionUtil.assertTrue("module must extend ModuleExtensionAware", extendedModule instanceof ModuleExtensionAware);
            ((ModuleExtensionAware)extendedModule).setExtensions(extensions);
        }
    }

    private void initializeModule(Module module, HashSet<Module> initializedModules) {
        if (!initializedModules.contains(module)) {
            initializedModules.add(module);
            if (this.extensionMap.containsKey(module)) {
                List<ModuleExtension> dependencies = this.extensionMap.getList(module);
                for (ModuleExtension dependencyExtension : dependencies) {
                    Class<? extends Module> targetModule = dependencyExtension.getTargetModule();
                    Optional<? extends Module> dependencyModule = this.getModule(targetModule);
                    PreconditionUtil.verify(dependencyModule.isPresent() || dependencyExtension.isOptional(), "module dependency from %s to %s not available, use CrnkBoot.addModoule(...) or service discovery to add the later", module.getModuleName(), targetModule);
                    if (!dependencyModule.isPresent()) continue;
                    this.initializeModule(dependencyModule.get(), initializedModules);
                }
            }
            if (module instanceof InitializingModule) {
                ((InitializingModule)module).init();
            }
        }
    }

    public HttpRequestContextProvider getHttpRequestContextProvider() {
        return this.httpRequestContextProvider;
    }

    private void applyRepositoryRegistrations() {
        List<Object> repositories = this.filterDecorators(this.aggregatedModule.getRepositories());
        for (Object e : repositories) {
            this.applyRepositoryRegistration(e);
        }
    }

    protected Set<Class> findResourceClasses() {
        HashSet<Class> resourceClasses = new HashSet<Class>();
        resourceClasses.addAll(this.getResourceLookup().getResourceClasses());
        if (this.resourceRegistry != null) {
            resourceClasses.addAll(this.resourceRegistry.getResources().stream().map(it -> it.getResourceInformation().getResourceClass()).collect(Collectors.toList()));
        }
        for (Class resourceClass : new ArrayList(resourceClasses)) {
            this.findChildResources(resourceClasses, resourceClass);
        }
        return resourceClasses;
    }

    private void applyResourceRegistrations() {
        Set<Class> resourceClasses = this.findResourceClasses();
        HashMap<Class, RegistryEntry> addtionalEntryMap = new HashMap<Class, RegistryEntry>();
        for (Class resourceClass : resourceClasses) {
            if (this.resourceRegistry.getEntry(resourceClass) != null) continue;
            this.applyResourceRegistration(resourceClass, addtionalEntryMap);
        }
    }

    private void findChildResources(Set<Class> resourceClasses, Class clazz) {
        JsonApiResource annotation = clazz.getDeclaredAnnotation(JsonApiResource.class);
        if (annotation != null) {
            Class[] subTypes;
            for (Class subType : subTypes = annotation.subTypes()) {
                if (resourceClasses.contains(subType)) continue;
                resourceClasses.add(subType);
                this.findChildResources(resourceClasses, subType);
            }
        }
    }

    private RegistryEntry applyResourceRegistration(Class<?> resourceClass, Map<Class, RegistryEntry> additionalEntryMap) {
        if (additionalEntryMap.containsKey(resourceClass)) {
            return additionalEntryMap.get(resourceClass);
        }
        RegistryEntry entry = this.resourceRegistry.getEntry(resourceClass);
        if (entry == null) {
            Class<?> superclass = resourceClass.getSuperclass();
            if (!this.resourceInformationProvider.accept(superclass)) {
                throw new IllegalStateException("super type " + superclass + " of " + resourceClass + " is not a resource. Is it annotated with @JsonApiResource?");
            }
            RegistryEntry parentEntry = this.applyResourceRegistration(superclass, additionalEntryMap);
            LOGGER.debug("adding resource {}", resourceClass);
            PreconditionUtil.verify(parentEntry != null, "unable to find repository for resource type %s, make sure a repository is backing this type or one of its super types", resourceClass);
            PreconditionUtil.verify(this.resourceInformationProvider.accept(resourceClass), "make sure resource type %s is a valid resource, e.g. annotated with @JsonApiResource", resourceClass);
            ResourceInformation information = this.resourceInformationProvider.build(resourceClass);
            PreconditionUtil.verify(parentEntry.getResourceInformation().getResourcePath().equals(information.getResourcePath()), "resource type %s without repository implementation must specify a @JsonApiResource.resourcePath matching one of its parent repositories", resourceClass);
            RegistryEntryBuilder entryBuilder = this.getContext().newRegistryEntryBuilder();
            entryBuilder.resource().from(information);
            entry = entryBuilder.build();
            entry.setParentRegistryEntry(parentEntry);
            this.getContext().addRegistryEntry(entry);
            Class<?> parentClass = parentEntry.getResourceInformation().getResourceClass();
            PreconditionUtil.verify(resourceClass.getSuperclass().equals(parentClass), "%s must be a subType of %s", resourceClass, parentClass);
        }
        additionalEntryMap.put(resourceClass, entry);
        return entry;
    }

    private List<Object> filterDecorators(List<Object> repositories) {
        return repositories.stream().filter(it -> !(it instanceof ResourceRepositoryDecorator) && !(it instanceof RelationshipRepositoryDecorator)).collect(Collectors.toList());
    }

    private void applyRepositoryRegistration(Object repository) {
        if (repository instanceof HttpRequestContextAware) {
            ((HttpRequestContextAware)repository).setHttpRequestContextProvider(this.getHttpRequestContextProvider());
        }
        RegistryEntryBuilder entryBuilder = this.getContext().newRegistryEntryBuilder();
        entryBuilder.fromImplementation(repository);
        RegistryEntry entry = entryBuilder.build();
        if (entry != null) {
            this.resourceRegistry.addEntry(entry);
        }
    }

    public List<DocumentFilter> getFilters() {
        return Prioritizable.prioritze(this.aggregatedModule.getFilters());
    }

    public List<RepositoryFilter> getRepositoryFilters() {
        return Prioritizable.prioritze(this.aggregatedModule.getRepositoryFilters());
    }

    public List<RepositoryDecoratorFactory> getRepositoryDecoratorFactories() {
        return this.aggregatedModule.getRepositoryDecoratorFactories();
    }

    public ExceptionMapperLookup getExceptionMapperLookup() {
        return new CombinedExceptionMapperLookup(this.aggregatedModule.getExceptionMapperLookups());
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public <T extends Module> Optional<T> getModule(Class<T> clazz) {
        for (Module module : this.modules) {
            if (!clazz.isInstance(module)) continue;
            return Optional.of(module);
        }
        return Optional.empty();
    }

    public TypeParser getTypeParser() {
        return this.typeParser;
    }

    public Module.ModuleContext getContext() {
        return new ModuleContextImpl(null);
    }

    public ExceptionMapperRegistry getExceptionMapperRegistry() {
        PreconditionUtil.verify(this.exceptionMapperRegistry != null, "exceptionMapperRegistry not yet available, wait for initialization to complete", new Object[0]);
        return this.exceptionMapperRegistry;
    }

    public Map<String, ResourceRegistryPart> getRegistryParts() {
        return this.aggregatedModule.getRegistryParts();
    }

    public List<RegistryEntry> getRegistryEntries() {
        return this.aggregatedModule.getRegistryEntries();
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.typeParser.setObjectMapper(objectMapper);
    }

    public List<RepositoryAdapterFactory> getRepositoryAdapterFactories() {
        return this.aggregatedModule.getRepositoryAdapterFactories();
    }

    public QuerySpecUrlMapper getUrlMapper() {
        return this.urlMapper;
    }

    public void setUrlMapper(QuerySpecUrlMapper urlMapper) {
        this.urlMapper = urlMapper;
        if (urlMapper != null) {
            this.urlMapper.init(new QuerySpecUrlContext(){

                @Override
                public ResourceRegistry getResourceRegistry() {
                    return ModuleRegistry.this.getResourceRegistry();
                }

                @Override
                public TypeParser getTypeParser() {
                    return ModuleRegistry.this.getTypeParser();
                }

                @Override
                public ObjectMapper getObjectMapper() {
                    return ModuleRegistry.this.objectMapper;
                }
            });
        }
    }

    public PagingBehavior findPagingBehavior(Class<? extends PagingSpec> pagingSpecType) {
        if (pagingSpecType == null) {
            return null;
        }
        List<PagingBehavior> pagingBehaviors = this.getPagingBehaviors();
        PreconditionUtil.verify(!pagingBehaviors.isEmpty(), "no paging behaviors installed", new Object[0]);
        for (PagingBehavior pagingBehavior : pagingBehaviors) {
            if (pagingSpecType != PagingSpec.class && !pagingBehavior.supports(pagingSpecType)) continue;
            return pagingBehavior;
        }
        throw new IllegalStateException("no pagingBehavior implementation available for " + pagingSpecType);
    }

    class ModuleContextImpl
    implements Module.ModuleContext {
        private final Module module;

        public ModuleContextImpl(Module module) {
            this.module = module;
        }

        @Override
        public void addPagingBehavior(PagingBehavior pagingBehavior) {
            LOGGER.debug("adding paging behavior {}", (Object)pagingBehavior);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addPagingBehavior(pagingBehavior);
        }

        @Override
        public void addResourceInformationBuilder(ResourceInformationProvider resourceInformationProvider) {
            LOGGER.debug("adding resource information provider {}", (Object)resourceInformationProvider);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addResourceInformationProvider(resourceInformationProvider);
        }

        @Override
        public void addRepositoryInformationBuilder(RepositoryInformationProvider repositoryInformationProvider) {
            LOGGER.debug("adding repository information provider {}", (Object)repositoryInformationProvider);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addRepositoryInformationBuilder(repositoryInformationProvider);
        }

        @Override
        public void addResourceLookup(ResourceLookup resourceLookup) {
            LOGGER.debug("adding resource lookup {}", (Object)resourceLookup);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addResourceLookup(resourceLookup);
        }

        @Override
        public void addJacksonModule(com.fasterxml.jackson.databind.Module module) {
            LOGGER.debug("adding jackson module {}", (Object)module);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addJacksonModule(module);
        }

        @Override
        public ResourceRegistry getResourceRegistry() {
            ModuleRegistry.this.checkState(InitializedState.INITIALIZING, InitializedState.INITIALIZED);
            if (ModuleRegistry.this.resourceRegistry == null) {
                throw new IllegalStateException("resourceRegistry not yet available");
            }
            return ModuleRegistry.this.resourceRegistry;
        }

        @Override
        public void addFilter(DocumentFilter filter) {
            LOGGER.debug("adding document filter {}", (Object)filter);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addFilter(filter);
        }

        @Override
        public void addExceptionMapperLookup(ExceptionMapperLookup exceptionMapperLookup) {
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addExceptionMapperLookup(exceptionMapperLookup);
        }

        @Override
        public void addExceptionMapper(ExceptionMapper<?> exceptionMapper) {
            LOGGER.debug("adding exception mapper {}", exceptionMapper);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addExceptionMapper(exceptionMapper);
        }

        @Override
        public void addRepository(Class<?> type, Object repository) {
            LOGGER.debug("adding repository {}", repository);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.INITIALIZING);
            ModuleRegistry.this.aggregatedModule.addRepository(repository);
        }

        @Override
        public void addRepository(Class<?> sourceType, Class<?> targetType, Object repository) {
            LOGGER.debug("adding repository {}", repository);
            ModuleRegistry.this.aggregatedModule.addRepository(repository);
        }

        @Override
        public void addSecurityProvider(SecurityProvider securityProvider) {
            LOGGER.debug("adding security provider {}", (Object)securityProvider);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addSecurityProvider(securityProvider);
        }

        @Override
        public SecurityProvider getSecurityProvider() {
            ModuleRegistry.this.checkState(InitializedState.INITIALIZING, InitializedState.INITIALIZED);
            return ModuleRegistry.this.getSecurityProvider();
        }

        @Override
        public void setResultFactory(ResultFactory resultFactory) {
            ModuleRegistry.this.setResultFactory(resultFactory);
        }

        @Override
        public void addExtension(ModuleExtension extension) {
            LOGGER.debug("adding extension {}", (Object)extension);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addExtension(extension);
            ModuleRegistry.this.extensionMap.add(this.module, extension);
        }

        @Override
        public void addHttpRequestProcessor(HttpRequestProcessor processor) {
            LOGGER.debug("adding http request processor {}", (Object)processor);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addHttpRequestProcessor(processor);
        }

        @Override
        public ObjectMapper getObjectMapper() {
            PreconditionUtil.verify(ModuleRegistry.this.objectMapper != null, "objectMapper not yet available before initialization", new Object[0]);
            return ModuleRegistry.this.objectMapper;
        }

        @Override
        public void addRegistryPart(String prefix, ResourceRegistryPart part) {
            LOGGER.debug("adding registry part {}", (Object)part);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addRegistryPart(prefix, part);
        }

        @Override
        public ServiceDiscovery getServiceDiscovery() {
            return ModuleRegistry.this.getServiceDiscovery();
        }

        @Override
        public void addRepositoryFilter(RepositoryFilter filter) {
            LOGGER.debug("adding repository filter {}", (Object)filter);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addRepositoryFilter(filter);
        }

        @Override
        public void addResourceFilter(ResourceFilter filter) {
            LOGGER.debug("adding resource filter {}", (Object)filter);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addResourceFilter(filter);
        }

        @Override
        public void addResourceFieldContributor(ResourceFieldContributor contributor) {
            LOGGER.debug("adding resource field contributor {}", (Object)contributor);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addResourceFieldContributor(contributor);
        }

        @Override
        public void addRepositoryDecoratorFactory(RepositoryDecoratorFactory decoratorFactory) {
            LOGGER.debug("adding repository decorator factory {}", (Object)decoratorFactory);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.NOT_INITIALIZED);
            ModuleRegistry.this.aggregatedModule.addRepositoryDecoratorFactory(decoratorFactory);
        }

        @Override
        public void addRepository(Object repository) {
            LOGGER.debug("adding repository {}", repository);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.INITIALIZING);
            ModuleRegistry.this.aggregatedModule.addRepository(repository);
        }

        @Override
        public boolean isServer() {
            return ModuleRegistry.this.isServer;
        }

        @Override
        public TypeParser getTypeParser() {
            return ModuleRegistry.this.typeParser;
        }

        @Override
        public ResourceInformationProvider getResourceInformationBuilder() {
            ModuleRegistry.this.checkState(InitializedState.INITIALIZING, InitializedState.INITIALIZED);
            return ModuleRegistry.this.getResourceInformationBuilder();
        }

        @Override
        public ExceptionMapperRegistry getExceptionMapperRegistry() {
            ModuleRegistry.this.checkState(InitializedState.INITIALIZING, InitializedState.INITIALIZED);
            return ModuleRegistry.this.getExceptionMapperRegistry();
        }

        @Override
        public RequestDispatcher getRequestDispatcher() {
            ModuleRegistry.this.checkState(InitializedState.INITIALIZING, InitializedState.INITIALIZED);
            return ModuleRegistry.this.requestDispatcher;
        }

        @Override
        public RegistryEntryBuilder newRegistryEntryBuilder() {
            return new DefaultRegistryEntryBuilder(ModuleRegistry.this);
        }

        @Override
        public void addRegistryEntry(RegistryEntry entry) {
            LOGGER.debug("adding registry entry {}", (Object)entry);
            ModuleRegistry.this.checkState(InitializedState.NOT_INITIALIZED, InitializedState.INITIALIZING);
            ModuleRegistry.this.aggregatedModule.addRegistryEntry(entry);
        }

        @Override
        public ResourceFilterDirectory getResourceFilterDirectory() {
            ModuleRegistry.this.checkState(InitializedState.INITIALIZING, InitializedState.INITIALIZED);
            return ModuleRegistry.this.filterBehaviorProvider;
        }

        @Override
        public void addResourceModificationFilter(ResourceModificationFilter filter) {
            LOGGER.debug("adding resource modification filter  {}", (Object)filter);
            ModuleRegistry.this.aggregatedModule.addResourceModificationFilter(filter);
        }

        @Override
        public ResultFactory getResultFactory() {
            return ModuleRegistry.this.resultFactory;
        }

        @Override
        public List<DocumentFilter> getDocumentFilters() {
            return ModuleRegistry.this.getFilters();
        }

        @Override
        public void addRepositoryAdapterFactory(RepositoryAdapterFactory repositoryAdapterFactory) {
            LOGGER.debug("adding repository adapter factory {}", (Object)repositoryAdapterFactory);
            ModuleRegistry.this.aggregatedModule.addRepositoryAdapterFactory(repositoryAdapterFactory);
        }

        @Override
        public ModuleRegistry getModuleRegistry() {
            return ModuleRegistry.this;
        }

        @Override
        public PropertiesProvider getPropertiesProvider() {
            return ModuleRegistry.this.propertiesProvider;
        }
    }

    static class CombinedExceptionMapperLookup
    implements ExceptionMapperLookup {
        private Collection<ExceptionMapperLookup> lookups;

        public CombinedExceptionMapperLookup(List<ExceptionMapperLookup> lookups) {
            this.lookups = lookups;
        }

        @Override
        public Set<JsonApiExceptionMapper> getExceptionMappers() {
            HashSet<JsonApiExceptionMapper> set = new HashSet<JsonApiExceptionMapper>();
            for (ExceptionMapperLookup lookup : this.lookups) {
                set.addAll(lookup.getExceptionMappers());
            }
            return set;
        }
    }

    static class CombinedRepositoryInformationProvider
    implements RepositoryInformationProvider {
        private Collection<RepositoryInformationProvider> builders;

        public CombinedRepositoryInformationProvider(List<RepositoryInformationProvider> builders) {
            this.builders = builders;
        }

        @Override
        public boolean accept(Object repository) {
            for (RepositoryInformationProvider builder : this.builders) {
                if (!builder.accept(repository)) continue;
                return true;
            }
            return false;
        }

        @Override
        public RepositoryInformation build(Object repository, RepositoryInformationProviderContext context) {
            for (RepositoryInformationProvider builder : this.builders) {
                if (!builder.accept(repository)) continue;
                return builder.build(repository, context);
            }
            throw new UnsupportedOperationException("no RepositoryInformationProvider available for " + repository.getClass().getName());
        }

        @Override
        public boolean accept(Class<?> repositoryClass) {
            for (RepositoryInformationProvider builder : this.builders) {
                if (!builder.accept(repositoryClass)) continue;
                return true;
            }
            return false;
        }

        @Override
        public RepositoryInformation build(Class<?> repositoryClass, RepositoryInformationProviderContext context) {
            for (RepositoryInformationProvider builder : this.builders) {
                if (!builder.accept(repositoryClass)) continue;
                return builder.build(repositoryClass, context);
            }
            throw new UnsupportedOperationException("no RepositoryInformationProvider available for " + repositoryClass.getName());
        }
    }

    static class CombinedResourceInformationProvider
    implements ResourceInformationProvider {
        private Collection<ResourceInformationProvider> builders;

        public CombinedResourceInformationProvider(List<ResourceInformationProvider> builders) {
            this.builders = builders;
        }

        @Override
        public boolean accept(Class<?> resourceClass) {
            for (ResourceInformationProvider builder : this.builders) {
                if (!builder.accept(resourceClass)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ResourceInformation build(Class<?> resourceClass) {
            for (ResourceInformationProvider builder : this.builders) {
                if (!builder.accept(resourceClass)) continue;
                return builder.build(resourceClass);
            }
            throw new UnsupportedOperationException("no ResourceInformationProvider available for " + resourceClass.getName());
        }

        @Override
        public String getResourceType(Class<?> resourceClass) {
            for (ResourceInformationProvider builder : this.builders) {
                if (!builder.accept(resourceClass)) continue;
                return builder.getResourceType(resourceClass);
            }
            return null;
        }

        @Override
        public String getResourcePath(Class<?> resourceClass) {
            for (ResourceInformationProvider builder : this.builders) {
                if (!builder.accept(resourceClass)) continue;
                return builder.getResourcePath(resourceClass);
            }
            return null;
        }

        @Override
        public void init(ResourceInformationProviderContext context) {
            for (ResourceInformationProvider builder : this.builders) {
                builder.init(context);
            }
        }
    }

    class AggregatedSecurityProvider
    implements SecurityProvider {
        private final List<SecurityProvider> securityProviders;

        public AggregatedSecurityProvider(List<SecurityProvider> securityProviders) {
            this.securityProviders = securityProviders;
        }

        @Override
        public boolean isUserInRole(String role) {
            PreconditionUtil.verify(this.securityProviders.size() != 0, "no SecurityProvider installed to check permissions", new Object[0]);
            for (SecurityProvider securityProvider : this.securityProviders) {
                if (!securityProvider.isUserInRole(role)) continue;
                return true;
            }
            return false;
        }
    }

    static enum InitializedState {
        NOT_INITIALIZED,
        INITIALIZING,
        INITIALIZED;

    }
}

