/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.registry;

import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistryPart;
import io.crnk.core.engine.registry.ResourceRegistryPartBase;
import io.crnk.core.engine.registry.ResourceRegistryPartEvent;
import io.crnk.core.engine.registry.ResourceRegistryPartListener;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HierarchicalResourceRegistryPart
extends ResourceRegistryPartBase {
    private static final String PATH_SEPARATOR = "/";
    private Map<String, ResourceRegistryPart> partMap = new HashMap<String, ResourceRegistryPart>();
    private List<ResourceRegistryPart> partList = new ArrayList<ResourceRegistryPart>();
    private ResourceRegistryPartListener childListener = new ResourceRegistryPartListener(){

        @Override
        public void onChanged(ResourceRegistryPartEvent event) {
            HierarchicalResourceRegistryPart.this.notifyChange();
        }
    };

    public void putPart(String prefix, ResourceRegistryPart part) {
        if (this.partMap.containsKey(prefix)) {
            throw new IllegalStateException("part with prefx " + prefix + " already exists");
        }
        this.partMap.put(prefix, part);
        this.partList.add(part);
        part.addListener(this.childListener);
    }

    @Override
    public RegistryEntry addEntry(RegistryEntry entry) {
        String resourceType = entry.getResourceInformation().getResourceType();
        ResourceRegistryPart part = this.getPart(resourceType);
        if (part == null) {
            throw new IllegalStateException("cannot add " + resourceType + ", no part available in hierarchy");
        }
        return part.addEntry(entry);
    }

    @Override
    public boolean hasEntry(Class<?> implementationClass) {
        for (ResourceRegistryPart part : this.partList) {
            if (!part.hasEntry(implementationClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEntry(Type implementationType) {
        for (ResourceRegistryPart part : this.partList) {
            if (!part.hasEntry(implementationType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEntry(String resourceType) {
        for (ResourceRegistryPart part : this.partList) {
            if (!part.hasEntry(resourceType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RegistryEntry getEntry(String resourceType) {
        ResourceRegistryPart part = this.getPart(resourceType);
        if (part == null) {
            return null;
        }
        return part.getEntry(resourceType);
    }

    @Override
    public RegistryEntry getEntryByPath(String resourcePath) {
        ResourceRegistryPart part = this.getPart(resourcePath);
        if (part == null) {
            return null;
        }
        return part.getEntryByPath(resourcePath);
    }

    private ResourceRegistryPart getPart(String resourceType) {
        int sep = resourceType.indexOf(PATH_SEPARATOR);
        String prefix = sep == -1 ? "" : resourceType.substring(0, sep);
        return this.partMap.get(prefix);
    }

    @Override
    public Collection<RegistryEntry> getResources() {
        ArrayList<RegistryEntry> list = new ArrayList<RegistryEntry>();
        for (ResourceRegistryPart part : this.partList) {
            list.addAll(part.getResources());
        }
        return list;
    }

    @Override
    public RegistryEntry getEntry(Class<?> implementationClass) {
        for (ResourceRegistryPart part : this.partList) {
            if (!part.hasEntry(implementationClass)) continue;
            return part.getEntry(implementationClass);
        }
        return null;
    }

    @Override
    public RegistryEntry getEntry(Type implementationType) {
        for (ResourceRegistryPart part : this.partList) {
            if (!part.hasEntry(implementationType)) continue;
            return part.getEntry(implementationType);
        }
        return null;
    }
}

