/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.registry;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistryPartBase;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceRegistryPart
extends ResourceRegistryPartBase {
    private final Logger logger = LoggerFactory.getLogger(DefaultResourceRegistryPart.class);
    private final Map<String, RegistryEntry> resourcesByType = new HashMap<String, RegistryEntry>();
    private final Map<String, RegistryEntry> resourcesByPath = new HashMap<String, RegistryEntry>();
    private final Map<Type, RegistryEntry> resourcesByImplementationType = new HashMap<Type, RegistryEntry>();

    @Override
    public RegistryEntry addEntry(RegistryEntry entry) {
        ResourceInformation resourceInformation = entry.getResourceInformation();
        Type implementationType = resourceInformation.getImplementationType();
        String resourceType = resourceInformation.getResourceType();
        String resourcePath = resourceInformation.getResourcePath();
        PreconditionUtil.verify(resourceType != null, "no resourceType set for entry %d", entry);
        PreconditionUtil.verify(!this.resourcesByType.containsKey(resourceType), "resourceType '%s' already exists, cannot add entry %s", resourceType, entry);
        if (entry.hasResourceRepository()) {
            PreconditionUtil.verify(!this.resourcesByPath.containsKey(resourcePath), "resourceType '%s' already exists, cannot add entry %s", resourcePath, entry);
            this.resourcesByPath.put(resourcePath != null ? resourcePath : resourceType, entry);
        }
        this.resourcesByImplementationType.put(implementationType, entry);
        this.resourcesByType.put(resourceType, entry);
        this.logger.debug("Added resource '{}' to ResourceRegistry", (Object)resourceType);
        this.notifyChange();
        return entry;
    }

    @Override
    public boolean hasEntry(Class<?> implementationClass) {
        return this.getEntry(implementationClass) != null;
    }

    @Override
    public boolean hasEntry(Type implementationType) {
        return this.getEntry(implementationType) != null;
    }

    @Override
    public boolean hasEntry(String resourceType) {
        return this.getEntry(resourceType) != null;
    }

    @Override
    public RegistryEntry getEntry(Class<?> implementationClass) {
        return this.resourcesByImplementationType.get(implementationClass);
    }

    @Override
    public RegistryEntry getEntry(Type implementationType) {
        return this.resourcesByImplementationType.get(implementationType);
    }

    public Set<RegistryEntry> getResources() {
        return Collections.unmodifiableSet(new HashSet<RegistryEntry>(this.resourcesByType.values()));
    }

    @Override
    public RegistryEntry getEntry(String resourceType) {
        return this.resourcesByType.get(resourceType);
    }

    @Override
    public RegistryEntry getEntryByPath(String resourcePath) {
        return this.resourcesByPath.get(resourcePath);
    }
}

