/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.parser;

import io.crnk.core.engine.parser.ParserException;
import io.crnk.core.engine.parser.StringMapper;
import io.crnk.core.engine.parser.ToStringStringMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class DefaultStringParsers {
    private DefaultStringParsers() {
    }

    public static Map<Class, StringMapper> get() {
        HashMap<Class, StringMapper> parsers = new HashMap<Class, StringMapper>();
        DefaultStringParsers.addType(parsers, Arrays.asList(Byte.class, Byte.TYPE), new ToStringStringMapper<Byte>(){

            @Override
            public Byte parse(String input) {
                return Byte.valueOf(input);
            }
        });
        DefaultStringParsers.addType(parsers, Arrays.asList(Short.class, Short.TYPE), new ToStringStringMapper<Short>(){

            @Override
            public Short parse(String input) {
                return Short.valueOf(input);
            }
        });
        DefaultStringParsers.addType(parsers, Arrays.asList(Integer.class, Integer.TYPE), new ToStringStringMapper<Integer>(){

            @Override
            public Integer parse(String input) {
                return Integer.valueOf(input);
            }
        });
        DefaultStringParsers.addType(parsers, Arrays.asList(Long.class, Long.TYPE), new ToStringStringMapper<Long>(){

            @Override
            public Long parse(String input) {
                return Long.valueOf(input);
            }
        });
        DefaultStringParsers.addType(parsers, Arrays.asList(Float.class, Float.TYPE), new ToStringStringMapper<Float>(){

            @Override
            public Float parse(String input) {
                return Float.valueOf(input);
            }
        });
        DefaultStringParsers.addType(parsers, Arrays.asList(Double.class, Double.TYPE), new ToStringStringMapper<Double>(){

            @Override
            public Double parse(String input) {
                return Double.valueOf(input);
            }
        });
        DefaultStringParsers.addType(parsers, Collections.singletonList(BigInteger.class), new ToStringStringMapper<BigInteger>(){

            @Override
            public BigInteger parse(String input) {
                return new BigInteger(input);
            }
        });
        DefaultStringParsers.addType(parsers, Collections.singletonList(BigDecimal.class), new ToStringStringMapper<BigDecimal>(){

            @Override
            public BigDecimal parse(String input) {
                return new BigDecimal(input);
            }
        });
        DefaultStringParsers.addType(parsers, Arrays.asList(Character.class, Character.TYPE), new ToStringStringMapper<Character>(){

            @Override
            public Character parse(String input) {
                if (input.length() != 1) {
                    throw DefaultStringParsers.newException(Character.class, input);
                }
                return Character.valueOf(input.charAt(0));
            }
        });
        DefaultStringParsers.addType(parsers, Arrays.asList(Boolean.class, Boolean.TYPE), new ToStringStringMapper<Boolean>(){

            @Override
            public Boolean parse(String input) {
                String inputNormalized = input.toLowerCase();
                if ("true".equals(inputNormalized) || "t".equals(inputNormalized)) {
                    return true;
                }
                if ("false".equals(inputNormalized) || "f".equals(inputNormalized)) {
                    return false;
                }
                throw DefaultStringParsers.newException(Boolean.class, input);
            }
        });
        DefaultStringParsers.addType(parsers, Collections.singletonList(UUID.class), new ToStringStringMapper<UUID>(){

            @Override
            public UUID parse(String input) {
                try {
                    return UUID.fromString(input);
                }
                catch (IllegalArgumentException e) {
                    throw new ParserException("not a valid uuid", e);
                }
            }
        });
        return parsers;
    }

    private static <T> void addType(Map<Class, StringMapper> parsers, List<Class<T>> classes, StringMapper<T> standardTypeParser) {
        for (Class<T> clazz : classes) {
            parsers.put(clazz, standardTypeParser);
        }
    }

    private static ParserException newException(Class clazz, String input) {
        return new ParserException(String.format("String cannot be casted to %s: %s", clazz, input));
    }
}

